package online.shuita.gitee.mojo.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import online.shuita.gitee.mojo.model.*;
import online.shuita.gitee.mojo.utils.MarkDown2HtmlUtils;
import online.shuita.gitee.mojo.utils.StringUtil;
import online.shuita.gitee.mojo.utils.WikiUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@NoArgsConstructor
public class WikiGenerator extends AbsGenerator {
    private static String rootPath = "https://wiki.amh-group.com";

    static {
        //注册文档生成器
        try {
            GeneratorManager.getManager().registGenerator(WikiGenerator.class.newInstance());
            log.info("注册成功");
        } catch (Throwable e) {
            log.error("regist error", e);
        }
    }

    @Override
    public void generateDoc(AnalyResult analyResult, Map<String, String> properties) {
        log.info(properties.get("domainName"));
        String domainName = properties.get("domainName");
        log.info(properties.get("title"));
        String title = properties.get("title");
        log.info(properties.get("parentPageId"));
        String parentPageIdStr = properties.get("parentPageId");
        log.info(properties.get("spaceKey"));
        String spaceKey = properties.get("spaceKey");
        log.info(properties.get("userName"));
        String userName = properties.get("userName");
        log.info(properties.get("password"));
        String password = properties.get("password");
        if (StringUtils.isBlank(parentPageIdStr)
                || StringUtils.isBlank(spaceKey)
                || StringUtils.isBlank(userName)
                || StringUtils.isBlank(password)) {
            return;
        }
        if (StringUtils.isBlank(domainName)) {
            domainName = rootPath;
        }
        if (StringUtils.isBlank(title)) {
            title = "%s接口文档";
        }
        Long parentPageId = Long.valueOf(parentPageIdStr);

        Map<String, String> mdMap = doGenerateDoc(analyResult);

        String fdomainName = domainName;
        String ftitle = title;
        Map<String, String> params = Maps.newHashMap();
        mdMap.entrySet().forEach(entry -> {
            params.put("bizDomain", entry.getKey());
            String pageTitle = StringUtil.procTemp(ftitle, params);
            String context = MarkDown2HtmlUtils.markdown2Html(entry.getValue());
//            try {
//                FileUtils.write(new File("D:\\data\\api.md"), entry.getValue(), "utf-8", false);
//                FileUtils.write(new File("D:\\data\\api.html"), context, "utf-8", false);
//            } catch (IOException e) {
//                e.printStackTrace();
//            }

            String menu = String.format("<p><img class=\"editor-inline-macro\" data-macro-name=\"toc\" data-macro-schema-version=\"1\" src=\"%s/plugins/servlet/confluence/placeholder/macro?definition=e3RvY30&amp;locale=zh_CN&amp;version=2\"></img></p>\n",
                    fdomainName);
            WikiUtils.PageInfo pageInfo = WikiUtils.getPageIdByTitle(fdomainName, pageTitle, parentPageId, userName, password);
            if (null == pageInfo) {
                WikiUtils.createNewPage(fdomainName, pageTitle, menu + context, spaceKey, parentPageId, userName, password);
            } else {
                WikiUtils.updatePageContext(fdomainName, pageTitle, menu + context, spaceKey, pageInfo.getId(), pageInfo.getVersion() + 1, userName, password);
            }
        });

    }

}