/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import online.shuita.gitee.mojo.generator.IGenerator;
import online.shuita.gitee.mojo.model.AnalyResult;
import online.shuita.gitee.mojo.model.FieldModel;
import online.shuita.gitee.mojo.model.IntfModel;
import online.shuita.gitee.mojo.model.MethodModel;
import online.shuita.gitee.mojo.model.ParameterModel;
import online.shuita.gitee.mojo.model.PojoModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsGenerator
implements IGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbsGenerator.class);

    protected Map<String, String> doGenerateDoc(AnalyResult analyResult) {
        HashMap outMap = Maps.newHashMap();
        List<IntfModel> intfList = analyResult.getIntfModelList();
        Map<String, List<IntfModel>> intfMap = intfList.stream().collect(Collectors.groupingBy(IntfModel::getDomain));
        intfMap.entrySet().forEach(entry -> {
            String domain = (String)entry.getKey() + "";
            if (!outMap.containsKey(domain)) {
                outMap.putIfAbsent(domain, new StringBuffer());
            }
            StringBuffer outBuffer = (StringBuffer)outMap.get(domain);
            try {
                IntfModel intf;
                int idx;
                outBuffer.append(String.format("# %s\u63a5\u53e3\u6e05\u5355  \n", domain));
                outBuffer.append("| \u5e8f\u53f7 | \u63a5\u53e3 | \u4e2d\u6587\u540d | \u5907\u6ce8 |  \n");
                outBuffer.append("| --- | --- | --- | --- |  \n");
                List sublist = (List)entry.getValue();
                for (idx = 0; idx < sublist.size(); ++idx) {
                    intf = (IntfModel)sublist.get(idx);
                    outBuffer.append(String.format("| %s | %s | %s | %s |  \n", idx + 1, this.converterHtmlStr(intf.getIntfShortName()), StringUtils.trimToEmpty((String)intf.getIntfDesc()), ""));
                }
                for (idx = 0; idx < sublist.size(); ++idx) {
                    intf = (IntfModel)sublist.get(idx);
                    outBuffer.append(String.format("### <span id=\"anchor%s\" name=\"anchor%s\">%s\u3001%s</span>  \n", idx + 1, idx + 1, idx + 1, this.converterHtmlStr(intf.getIntfShortName())));
                    List<MethodModel> methodModelList = intf.getMethodModelList();
                    for (int midx = 0; midx < methodModelList.size(); ++midx) {
                        this.generateMethodDoc(idx, midx, methodModelList.get(midx), outBuffer, analyResult.getPojoModelMap());
                    }
                }
            }
            catch (Throwable e) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", e);
            }
        });
        HashMap resultMap = Maps.newHashMap();
        outMap.entrySet().forEach(entry -> resultMap.putIfAbsent(entry.getKey(), ((StringBuffer)entry.getValue()).toString()));
        return resultMap;
    }

    private void generateMethodDoc(int intfIdx, int methodIdx, MethodModel methodModel, StringBuffer outBuffer, Map<String, List<PojoModel>> pojoModelMap) {
        try {
            outBuffer.append(String.format("#### %s.%s\u3001%s%s%s  \n", intfIdx + 1, methodIdx + 1, methodModel.getDeprecated() != false ? "~~" : "", this.converterHtmlStr(methodModel.getMethodShortName()), methodModel.getDeprecated() != false ? "~~" : ""));
            outBuffer.append("**\u63a5\u53e3\u540d\uff1a**  \n");
            outBuffer.append(String.format("%s  \n", this.converterHtmlStr(methodModel.getMethodName())));
            outBuffer.append("**\u63a5\u53e3\u8bf4\u660e\uff1a**  \n");
            outBuffer.append(String.format("%s  \n", StringUtils.trimToEmpty((String)methodModel.getMethodDesc())));
            outBuffer.append("**\u5165\u53c2\uff1a**  \n");
            outBuffer.append("<table>");
            outBuffer.append("<tr><th>\u5b57\u6bb5\u540d</th><th>\u7c7b\u578b</th><th>\u662f\u5426\u5fc5\u586b</th><th>\u5b57\u6bb5\u63cf\u8ff0</th></tr>");
            List<ParameterModel> paramList = methodModel.getParameterModelList();
            ArrayList pojoModelList = Lists.newArrayList();
            for (int pidx = 0; pidx < paramList.size(); ++pidx) {
                ParameterModel parm = paramList.get(pidx);
                outBuffer.append(String.format("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", this.converterHtmlStr(parm.getParameterName()), this.converterHtmlStr(parm.getTypeShotName()), "", StringUtils.trimToEmpty((String)parm.getDesc())));
                if (!pojoModelMap.containsKey(parm.getGenericType())) continue;
                pojoModelList.addAll((Collection)pojoModelMap.get(parm.getGenericType()));
            }
            if (null != pojoModelList) {
                ArrayList generatePojo = Lists.newArrayList();
                this.generatePojoDoc(pojoModelList.stream().distinct().collect(Collectors.toList()), outBuffer, pojoModelMap, generatePojo);
            }
            outBuffer.append("</table>\n\n");
            outBuffer.append("**\u51fa\u53c2\uff1a**  \n");
            outBuffer.append("<table>\n");
            outBuffer.append("<tr><th>\u5b57\u6bb5\u540d</th><th>\u7c7b\u578b</th><th>\u662f\u5426\u5fc5\u586b</th><th>\u5b57\u6bb5\u63cf\u8ff0</th></tr>\n");
            ArrayList outPojoModelList = Lists.newArrayList();
            if (pojoModelMap.containsKey(methodModel.getReturnGenericType())) {
                outPojoModelList.addAll((Collection)pojoModelMap.get(methodModel.getReturnGenericType()));
            } else {
                outBuffer.append(String.format("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", "returnValue", this.converterHtmlStr(methodModel.getReturnTypeShotName()), "\u662f", ""));
            }
            if (null != outPojoModelList) {
                ArrayList generatePojo = Lists.newArrayList();
                this.generatePojoDoc(outPojoModelList.stream().distinct().collect(Collectors.toList()), outBuffer, pojoModelMap, generatePojo);
            }
            outBuffer.append("</table>\n\n");
        }
        catch (Throwable e) {
            log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", e);
        }
    }

    private void generatePojoDoc(List<PojoModel> pojoModels, StringBuffer outBuffer, Map<String, List<PojoModel>> pojoModelMap, List<String> generatePojo) {
        pojoModels.forEach(pojo -> {
            if (generatePojo.contains(pojo.getType())) {
                return;
            }
            try {
                outBuffer.append(String.format("<tr><td colspan=\"4\"><b><i>%s</i></b></td></tr>\n", this.converterHtmlStr(pojo.getShortType())));
                List<FieldModel> paramList = pojo.getFieldEntryList();
                ArrayList pojoModelList = Lists.newArrayList();
                for (int pidx = 0; pidx < paramList.size(); ++pidx) {
                    FieldModel parm = paramList.get(pidx);
                    outBuffer.append(String.format("<tr><td>%s%s%s</td><td>%s</td><td>%s</td><td>%s</td></tr>\n", parm.getDeprecated() != false ? "<del>" : "", this.converterHtmlStr(parm.getName()), parm.getDeprecated() != false ? "</del>" : "", this.converterHtmlStr(parm.getShortType()), "", StringUtils.trimToEmpty((String)parm.getDesc())));
                    if (!pojoModelMap.containsKey(parm.getGenericType())) continue;
                    pojoModelList.addAll((Collection)pojoModelMap.get(parm.getGenericType()));
                }
                generatePojo.add(pojo.getType());
                if (null != pojoModelList && pojoModelList.size() > 0) {
                    this.generatePojoDoc(pojoModelList.stream().distinct().collect(Collectors.toList()), outBuffer, pojoModelMap, generatePojo);
                }
            }
            catch (Throwable e) {
                log.error("\u8f93\u51fa\u6587\u6863\u5931\u8d25", e);
            }
        });
    }

    private String converterHtmlStr(String str) {
        return str.replaceAll("<=", "<= &le;").replaceAll(">=", "&ge;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

