/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.generator;

import com.google.common.collect.Maps;
import java.util.Map;
import online.shuita.gitee.mojo.generator.IGenerator;

public class GeneratorManager {
    private static GeneratorManager manager;
    private static Map<String, Class<IGenerator>> generatorMap;

    public static GeneratorManager getManager() {
        if (manager == null) {
            manager = new GeneratorManager();
        }
        return manager;
    }

    public void registGenerator(IGenerator generator) {
        if (null == generatorMap) {
            generatorMap = Maps.newConcurrentMap();
        }
        generatorMap.putIfAbsent(generator.getClass().getName(), generator.getClass());
    }

    public void registGenerator(String name, Class<IGenerator> generator) {
        if (null == generatorMap) {
            generatorMap = Maps.newConcurrentMap();
        }
        generatorMap.putIfAbsent(name, generator);
    }

    public Class<IGenerator> getGenerator(String name) {
        if (null == generatorMap) {
            generatorMap = Maps.newConcurrentMap();
        }
        return generatorMap.get(name);
    }
}

