/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import online.shuita.gitee.mojo.annotation.IntfDomain;
import online.shuita.gitee.mojo.annotation.ShotName;
import online.shuita.gitee.mojo.doclet.ClassDoc;
import online.shuita.gitee.mojo.doclet.Doclet;
import online.shuita.gitee.mojo.doclet.MethodEntry;
import online.shuita.gitee.mojo.doclet.ParameterEntry;
import online.shuita.gitee.mojo.model.AnalyResult;
import online.shuita.gitee.mojo.model.FieldModel;
import online.shuita.gitee.mojo.model.IntfModel;
import online.shuita.gitee.mojo.model.MethodModel;
import online.shuita.gitee.mojo.model.ParameterModel;
import online.shuita.gitee.mojo.model.PojoModel;
import online.shuita.gitee.mojo.utils.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntfService {
    private static final Logger log = LoggerFactory.getLogger(IntfService.class);
    private static Doclet doclet = null;
    private static List<String> excludeField = Arrays.asList("class");
    private String sourceBasePath;
    private List<String> compileClasspathElements;
    private ClassLoader loader;
    private Map<String, ClassDoc> docMap = Maps.newConcurrentMap();
    private Map<String, List<PojoModel>> pojoMap = Maps.newConcurrentMap();

    public AnalyResult doAnalyse(List<Class> intfCls, ClassLoader loader) {
        log.info("start doAnalyse. class array size =" + intfCls.size());
        if (null == loader) {
            return null;
        }
        this.loader = loader;
        if (null == doclet) {
            doclet = new Doclet(this.compileClasspathElements, loader);
        }
        if (null != intfCls) {
            try {
                ArrayList mdlList = Lists.newArrayList();
                for (Class cls : intfCls) {
                    IntfModel intfModel = this.doAnalyseClass(cls);
                    log.info("end doAnalyse. class=" + cls.getName());
                    mdlList.add(intfModel);
                }
                return AnalyResult.builder().intfModelList(mdlList).pojoModelMap(this.pojoMap).build();
            }
            catch (Throwable e) {
                log.error("\u5931\u8d25", e);
            }
        }
        return null;
    }

    public AnalyResult doAnalyse(Class intfCls, ClassLoader loader) {
        log.info("start doAnalyse. class=" + intfCls.getName());
        if (null == loader) {
            return null;
        }
        this.loader = loader;
        if (null == doclet) {
            doclet = new Doclet(this.compileClasspathElements, loader);
        }
        if (null != intfCls) {
            try {
                IntfModel intfModel = this.doAnalyseClass(intfCls);
                log.info("end doAnalyse. class=" + intfCls.getName());
                return AnalyResult.builder().intfModelList(Lists.newArrayList((Object[])new IntfModel[]{intfModel})).pojoModelMap(this.pojoMap).build();
            }
            catch (Throwable e) {
                log.error("\u5931\u8d25", e);
            }
        }
        return null;
    }

    private IntfModel doAnalyseClass(Class intfCls) {
        IntfModel intfModel = IntfModel.builder().intfName(intfCls.getName()).pkgName(intfCls.getPackage().getName()).build();
        ShotName shotName = intfCls.getAnnotation(ShotName.class);
        if (shotName != null) {
            intfModel.setIntfShortName(shotName.value());
        } else {
            String[] ss = intfModel.getIntfName().split("[.]");
            intfModel.setIntfShortName(ss[ss.length - 1]);
        }
        IntfDomain domain = intfCls.getAnnotation(IntfDomain.class);
        if (domain != null) {
            intfModel.setDomain(domain.value());
        } else {
            intfModel.setDomain("");
        }
        ClassDoc doc = this.getDoc(intfCls.getName());
        if (null != doc) {
            intfModel.setIntfDesc(doc.getModelCommentText());
        }
        Method[] methods = intfCls.getMethods();
        intfModel.setMethodModelList(Arrays.stream(methods).map(method -> this.doAnalyseMethod((Method)method, intfCls)).collect(Collectors.toList()));
        return intfModel;
    }

    private MethodModel doAnalyseMethod(Method method, Class intfCls) {
        log.info("start analyse method={}", (Object)method.toString());
        MethodModel methodModel = MethodModel.builder().methodName(method.toString()).methodType(method.toString()).build();
        ShotName shotName = method.getAnnotation(ShotName.class);
        if (shotName != null) {
            methodModel.setMethodShortName(shotName.value());
        } else {
            methodModel.setMethodShortName(method.getName());
        }
        Deprecated deprecated = method.getAnnotation(Deprecated.class);
        methodModel.setDeprecated(deprecated != null);
        ClassDoc doc = this.getDoc(intfCls.getName());
        if (null != doc) {
            List ptypelist;
            String name;
            String clsName;
            String key;
            Map<String, MethodEntry> mMap = doc.getMethodEntryMap();
            MethodEntry entry = mMap.get(key = String.format("%s.%s(%s)", clsName = method.getDeclaringClass().getName(), name = method.getName(), String.join((CharSequence)", ", ptypelist = Arrays.stream(method.getParameterTypes()).map(item -> item.getName()).collect(Collectors.toList()))));
            if (null != entry) {
                methodModel.setMethodDesc(entry.getMExplain());
                Parameter[] parameters = method.getParameters();
                List<ParameterEntry> plist = entry.getParameterList();
                ArrayList parameterModelList = Lists.newArrayList();
                int idx = 0;
                for (Parameter p : parameters) {
                    parameterModelList.add(this.doAnalyseParameter(plist.get(idx++), p, intfCls));
                }
                methodModel.setParameterModelList(parameterModelList);
            } else {
                methodModel.setParameterModelList(Lists.newArrayList());
            }
        }
        methodModel.setReturnType(method.getReturnType().getName());
        methodModel.setReturnGenericType(method.getGenericReturnType().getTypeName());
        methodModel.setReturnTypeShotName(this.getShotType(method.getGenericReturnType()));
        methodModel.setMethodName(String.format("%s %s.%s(%s)", methodModel.getReturnTypeShotName(), this.getShotName(method.getDeclaringClass().getName()), method.getName(), String.join((CharSequence)", ", methodModel.getParameterModelList().stream().map(item -> item.getTypeShotName()).collect(Collectors.toList()))));
        methodModel.setMethodShortName(String.format("%s %s(%s)", methodModel.getReturnTypeShotName(), method.getName(), String.join((CharSequence)", ", methodModel.getParameterModelList().stream().map(item -> item.getTypeShotName()).collect(Collectors.toList()))));
        this.appendPojo(methodModel.getReturnType(), method.getGenericReturnType());
        return methodModel;
    }

    private ParameterModel doAnalyseParameter(ParameterEntry parameterDoc, Parameter parameter, Class intfCls) {
        ParameterModel model = ParameterModel.builder().parameterName(parameterDoc.getParameterName()).type(parameter.getType().getName()).genericType(parameter.getParameterizedType().getTypeName()).typeShotName(this.getShotType(parameter.getParameterizedType())).desc(parameterDoc.getParameterDesc()).build();
        this.appendPojo(model.getType(), parameter.getParameterizedType());
        return model;
    }

    private ClassDoc getDoc(String className) {
        String sourceFileName = this.sourceBasePath + Matcher.quoteReplacement(File.separator) + className.replaceAll("[.]", Matcher.quoteReplacement(File.separator)) + ".java";
        if (this.docMap.containsKey(sourceFileName)) {
            return this.docMap.get(sourceFileName);
        }
        ClassDoc doc = doclet.exec(sourceFileName);
        this.docMap.putIfAbsent(sourceFileName, doc);
        return doc;
    }

    private String getClassNameType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType().getTypeName();
        }
        return type.getTypeName();
    }

    private String getShotType(Type type) {
        log.info("{} getShotType:{}", (Object)type.getTypeName(), (Object)type.getClass().getName());
        if (type instanceof ParameterizedType) {
            return String.format("%s<%s>", this.getShotName(type.getTypeName()), Arrays.asList(((ParameterizedType)type).getActualTypeArguments()).stream().map(item -> this.getShotType((Type)item)).collect(Collectors.joining(", ")));
        }
        return String.format("%s", this.getShotName(type.getTypeName()));
    }

    private String getShotName(String name) {
        String[] ss = name.split("[.]");
        int idx = 0;
        for (String s : ss) {
            if (s.contains("<")) {
                return s.substring(0, s.indexOf("<"));
            }
            if (++idx != ss.length) continue;
            return s;
        }
        return "";
    }

    private List<PojoModel> appendPojo(String name, Type genericType) {
        log.info("\u89e3\u6790\u7c7b\uff1a{}", (Object)genericType.getTypeName());
        if (StringUtils.isBlank((CharSequence)name) || this.isBaseType(name) || this.isEnumType(name)) {
            return Lists.newArrayList();
        }
        if (this.pojoMap.containsKey(genericType.getTypeName())) {
            return this.pojoMap.get(genericType.getTypeName());
        }
        if (this.isCollectionType(name)) {
            this.pojoMap.putIfAbsent(genericType.getTypeName(), Lists.newArrayList());
            ArrayList models = Lists.newArrayList();
            if (genericType instanceof ParameterizedType) {
                Type[] types;
                for (Type t : types = ((ParameterizedType)genericType).getActualTypeArguments()) {
                    log.info("\u89e3\u6790\u96c6\u5408\u7c7b\u7684\u6cdb\u578b\u7c7b\u578b\uff1a{}", (Object)t.getTypeName());
                    models.addAll(this.appendPojo(this.getClassNameType(t), t));
                }
            }
            if (models.size() > 0) {
                this.pojoMap.get(genericType.getTypeName()).addAll(models.stream().distinct().collect(Collectors.toList()));
            } else {
                this.pojoMap.remove(genericType.getTypeName());
            }
            return models;
        }
        if (!this.pojoMap.containsKey(genericType.getTypeName())) {
            this.pojoMap.putIfAbsent(genericType.getTypeName(), Lists.newArrayList());
            ArrayList models = Lists.newArrayList();
            try {
                ShotName shotName;
                PojoModel pojo = PojoModel.builder().pojoName(name).type(name).genericType(genericType.getTypeName()).shortType(this.getShotType(genericType)).build();
                Class<?> target = this.loader.loadClass(name);
                log.info("=======================");
                log.info(target.toGenericString());
                HashMap generateParamTypeMap = Maps.newHashMap();
                if (genericType instanceof ParameterizedType) {
                    Type[] arr1 = ((ParameterizedType)genericType).getActualTypeArguments();
                    TypeVariable<Class<?>>[] arr2 = target.getTypeParameters();
                    log.info(((ParameterizedType)genericType).getActualTypeArguments().length + "");
                    for (int idx = 0; idx < arr1.length; ++idx) {
                        Type t1 = arr1[idx];
                        TypeVariable<Class<?>> t2 = arr2[idx];
                        generateParamTypeMap.putIfAbsent(t2.getTypeName(), t1);
                        log.info("{} = {}", (Object)t2.getTypeName(), (Object)t1.getTypeName());
                        models.addAll(this.appendPojo(this.getClassNameType(t1), t1));
                    }
                }
                if ((shotName = target.getAnnotation(ShotName.class)) != null) {
                    pojo.setPojoShortName(shotName.value());
                } else {
                    pojo.setPojoShortName(name);
                }
                ClassDoc doc = this.getDoc(target.getName());
                if (null != doc) {
                    pojo.setDesc(doc.getModelCommentText());
                }
                List<FieldModel> otherFieldModels = Arrays.stream(target.getMethods()).filter(m -> (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterCount() <= 0).map(m -> {
                    String mName = m.getName();
                    String fName = null;
                    if (mName.startsWith("get")) {
                        mName = mName.substring(3);
                        fName = mName.substring(0, 1).toLowerCase() + mName.substring(1);
                    } else if (mName.startsWith("is")) {
                        fName = mName.substring(0, 1).toLowerCase() + mName.substring(1);
                    }
                    Deprecated deprecated = m.getAnnotation(Deprecated.class);
                    Type type = m.getGenericReturnType();
                    Class cls = m.getReturnType();
                    log.info("{}\u662f\u5426\u662f\u6cdb\u578b\uff1a{}", (Object)type.getTypeName(), (Object)(type instanceof ParameterizedType));
                    if (type instanceof ParameterizedType) {
                        Type[] tt = ((ParameterizedType)type).getActualTypeArguments();
                        Type[] ptypes = new Type[tt.length];
                        int idx = 0;
                        for (Type t : tt) {
                            ptypes[idx++] = generateParamTypeMap.containsKey(t.getTypeName()) ? (Type)generateParamTypeMap.get(t.getTypeName()) : t;
                        }
                        ParameterizedType nType = TypeUtils.parameterize((Class)((Class)((ParameterizedType)type).getRawType()), (Type[])ptypes);
                        log.info("\u65b0\u7684\u7c7b\u578b\uff1a{}", (Object)nType.toString());
                        type = nType;
                        cls = (Class)((ParameterizedType)type).getRawType();
                    } else if (generateParamTypeMap.containsKey(type.getTypeName())) {
                        cls = (type = (Type)generateParamTypeMap.get(type.getTypeName())) instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
                    }
                    FieldModel field = FieldModel.builder().name(fName).type(cls.getName()).genericType(type.getTypeName()).shortType(this.getShotType(type)).deprecated(deprecated != null).build();
                    if (null != doc && null != doc.getFieldEntryMap() && doc.getFieldEntryMap().containsKey(fName)) {
                        field.setDesc(doc.getFieldEntryMap().get(fName).getfExplain());
                    }
                    if (!this.isBaseType(field.getType()) && !excludeField.contains(field.getName())) {
                        models.addAll(this.appendPojo(field.getType(), type));
                    }
                    return field;
                }).filter(item -> !excludeField.contains(item.getName())).collect(Collectors.toList());
                pojo.setFieldEntryList(otherFieldModels);
                models.add(0, pojo);
                this.pojoMap.get(genericType.getTypeName()).addAll(models.stream().distinct().collect(Collectors.toList()));
                return models;
            }
            catch (ClassNotFoundException e) {
                log.error("\u89e3\u6790Pojo\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable e) {
                log.error("\u89e3\u6790Pojo\u5931\u8d25", e);
            }
        }
        return Lists.newArrayList();
    }

    private boolean isBaseType(String type) {
        return ClassUtils.isBaseType(type);
    }

    private boolean isEnumType(String type) {
        Class<?> cls = null;
        try {
            cls = this.loader.loadClass(type);
            boolean is = ClassUtils.isEnumTypeClass(cls);
            log.info("{}\u662f\u5426\u662f\u679a\u4e3e\u7c7b\uff1a{}", (Object)type, (Object)is);
            return is;
        }
        catch (ClassNotFoundException e) {
            log.error("error", (Throwable)e);
            return false;
        }
    }

    private boolean isCollectionType(String type) {
        Class<?> cls = null;
        try {
            cls = this.loader.loadClass(type);
            boolean is = ClassUtils.isArrayTypeClass(cls) || ClassUtils.isListTypeClass(cls) || ClassUtils.isMapTypeClass(cls) || ClassUtils.isSetTypeClass(cls);
            log.info("{}\u662f\u5426\u662f\u96c6\u5408\u7c7b\uff1a{}", (Object)type, (Object)is);
            return is;
        }
        catch (ClassNotFoundException e) {
            log.error("error", (Throwable)e);
            return false;
        }
    }

    public void setSourceBasePath(String sourceBasePath) {
        this.sourceBasePath = sourceBasePath;
    }

    public void setCompileClasspathElements(List<String> compileClasspathElements) {
        this.compileClasspathElements = compileClasspathElements;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }
}

