/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HttpUtils {
    public static String doPutJsonData(String url, String data) {
        return HttpUtils.doPutJsonData(url, data, null, null);
    }

    public static String doPutJsonData(String url, String data, String userName, String password) {
        OkHttpClient okHttpClient = null;
        okHttpClient = StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password) ? new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(userName, password)).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build() : new OkHttpClient();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)data);
        Request request = new Request.Builder().url(url).put(body).build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doPostJsonData(String url, String data) {
        return HttpUtils.doPostJsonData(url, data, null, null);
    }

    public static String doPostJsonData(String url, String data, String userName, String password) {
        OkHttpClient okHttpClient = null;
        okHttpClient = StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password) ? new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(userName, password)).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build() : new OkHttpClient();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)JSON, (String)data);
        Request request = new Request.Builder().url(url).post(body).build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doGetRequest(String url) {
        return HttpUtils.doGetRequest(url, null, null);
    }

    public static String doGetRequest(String url, String userName, String password) {
        OkHttpClient okHttpClient = null;
        okHttpClient = StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password) ? new OkHttpClient.Builder().addInterceptor((Interceptor)new BasicAuthInterceptor(userName, password)).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build() : new OkHttpClient();
        Request request = new Request.Builder().url(url).build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            String rslt = response.body().string();
            System.out.println(rslt);
            return rslt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String data = "{\"id\":\"266080886\",\"type\":\"page\",\"title\":\"Test page aaa 1\",\"space\":{\"key\":\"~han.wang6@amh-group.com\"},\"body\":{\"storage\":{\"value\":\"<p>This is <br/> a new page</p>\",\"representation\":\"storage\"}},\n\"version\":{\"number\":2}}}";
        HttpUtils.doPutJsonData("https://wiki.amh-group.com/rest/api/content/266080886", data, "han.wang6@amh-group.com", "P@ssW0rd0216");
    }

    public static class BasicAuthInterceptor
    implements Interceptor {
        private String credentials;

        public BasicAuthInterceptor(String user, String password) {
            this.credentials = Credentials.basic((String)user, (String)password);
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Request authenticatedRequest = request.newBuilder().header("Authorization", this.credentials).build();
            return chain.proceed(authenticatedRequest);
        }
    }
}

