/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.utils;

import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static final Logger log = LoggerFactory.getLogger(StringUtil.class);
    public static final Pattern pattern = Pattern.compile("(?<=\\{\\{)[^\\{\\}]*(?=\\}\\})");

    private StringUtil() {
    }

    public static String procTemp(String temp, Map<String, String> context) {
        if (StringUtils.isNotEmpty((CharSequence)temp)) {
            log.info("temp is {}", (Object)temp);
            Matcher m = pattern.matcher(temp);
            while (m.find()) {
                String val;
                String key = m.group();
                if (StringUtils.isEmpty((CharSequence)key) || null == (val = context.get(key))) continue;
                temp = temp.replace("{{" + key + "}}", val.toString());
            }
            log.info("warning message is {}", (Object)temp);
            return temp;
        }
        return null;
    }

    public static String getRootPath(URL url) {
        String fileUrl = url.getFile();
        int pos = fileUrl.indexOf(33);
        if (-1 == pos) {
            return fileUrl;
        }
        return fileUrl.substring(5, pos);
    }

    public static String dotToSplash(String name) {
        return name.replaceAll("\\.", "/");
    }

    public static String trimExtension(String name) {
        int pos = name.indexOf(46);
        if (-1 != pos) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String trimURI(String uri) {
        String trimmed = uri.substring(1);
        int splashIndex = trimmed.indexOf(47);
        return trimmed.substring(splashIndex);
    }
}

