package online.shuita.gitee.mojo.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class WikiUtils {

    public static PageInfo getPageIdByTitle(String domainName, String title, Long parentId, String userName, String password) {
        String rsltStr = HttpUtils.doGetRequest(String.format("%s/rest/api/content/%s/child/page?expand=version", domainName, parentId),
                userName, password);
        if (StringUtils.isNotBlank(rsltStr)) {
            JSONObject jobj = JSONObject.parseObject(rsltStr);
            JSONArray results = jobj.getJSONArray("results");
            if (null != results && results.size() > 0) {
                return results.stream().filter(item -> {
                    String pagetitle = ((JSONObject) item).getString("title");
                    return StringUtils.isNotBlank(pagetitle) && pagetitle.equals(title);
                }).map(item -> {
                    return PageInfo.builder()
                            .id(((JSONObject) item).getLong("id"))
                            .version(((JSONObject) item).getJSONObject("version").getInteger("number"))
                            .build();
                }).findFirst().orElse(null);
            }
        }
        return null;
    }

    public static PageInfo createNewPage(String domainName, String title, String context, String spaceKey, Long parentId, String userName, String password) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("type", "page");
        dataObj.put("title", title);
        dataObj.put("space", JSONObject.parseObject(String.format("{\"key\":\"%s\"}", spaceKey)));

        JSONObject body = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("value", context);
//        storage.put("representation", "storage");
//        body.put("storage", storage);
        storage.put("representation", "editor");
        body.put("editor", storage);

        dataObj.put("body", body);
        dataObj.put("ancestors", JSONArray.parseArray(String.format("[{\"id\":\"%s\",\"type\":\"page\"}]", parentId)));

//        String data = "{\"type\":\"page\",\"title\":\"Test page\",\"space\":{\"key\":\"~han.wang6@amh-group.com\"},\"body\":{\"storage\":{\"value\":\"<p>This is <br/> a new page</p>\",\"representation\":\"storage\"}},\"ancestors\":[{\"id\":\"146506805\",\"type\":\"page\"}]}";
        String rsltStr = HttpUtils.doPostJsonData(String.format("%s/rest/api/content", domainName), dataObj.toJSONString(),
                userName, password);
        if (StringUtils.isNotBlank(rsltStr)) {
            JSONObject jobj = JSONObject.parseObject(rsltStr);
            return PageInfo.builder()
                    .id(jobj.getLong("id"))
                    .version(jobj.getJSONObject("version").getInteger("number"))
                    .build();
        }
        return null;
    }

    public static PageInfo updatePageContext(String domainName, String title, String context, String spaceKey, Long pageId, Integer version, String userName, String password) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", pageId);
        dataObj.put("type", "page");
        dataObj.put("title", title);
        dataObj.put("space", JSONObject.parseObject(String.format("{\"key\":\"%s\"}", spaceKey)));
        dataObj.put("version", JSONObject.parseObject(String.format("{\"number\":%s}", version)));

        JSONObject body = new JSONObject();
        JSONObject storage = new JSONObject();
        storage.put("value", context);
        storage.put("representation", "editor");
        body.put("editor", storage);

        dataObj.put("body", body);

        String rsltStr = HttpUtils.doPutJsonData(String.format("%s/rest/api/content/%s", domainName, pageId), dataObj.toJSONString(),
                userName, password);
        if (StringUtils.isNotBlank(rsltStr)) {
            JSONObject jobj = JSONObject.parseObject(rsltStr);
            return PageInfo.builder()
                    .id(jobj.getLong("id"))
                    .version(jobj.getJSONObject("version").getInteger("number"))
                    .build();
        }
        return null;
    }


    @Getter
    @Setter
    @Builder
    public static class PageInfo {
        private Long id;
        private Integer version;
    }
}
