/*
 * Decompiled with CFR 0.152.
 */
package online.shuita.gitee.mojo.generator;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import online.shuita.gitee.mojo.generator.AbsGenerator;
import online.shuita.gitee.mojo.generator.GeneratorManager;
import online.shuita.gitee.mojo.generator.IGenerator;
import online.shuita.gitee.mojo.model.AnalyResult;
import online.shuita.gitee.mojo.utils.MarkDown2HtmlUtils;
import online.shuita.gitee.mojo.utils.StringUtil;
import online.shuita.gitee.mojo.utils.WikiUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikiGenerator
extends AbsGenerator {
    private static final Logger log = LoggerFactory.getLogger(WikiGenerator.class);
    private static String rootPath = "https://wiki.amh-group.com";

    @Override
    public void generateDoc(AnalyResult analyResult, Map<String, String> properties) {
        log.info(properties.get("domainName"));
        String domainName = properties.get("domainName");
        log.info(properties.get("title"));
        String title = properties.get("title");
        log.info(properties.get("parentPageId"));
        String parentPageIdStr = properties.get("parentPageId");
        log.info(properties.get("spaceKey"));
        String spaceKey = properties.get("spaceKey");
        log.info(properties.get("userName"));
        String userName = properties.get("userName");
        log.info(properties.get("password"));
        String password = properties.get("password");
        if (StringUtils.isBlank((CharSequence)parentPageIdStr) || StringUtils.isBlank((CharSequence)spaceKey) || StringUtils.isBlank((CharSequence)userName) || StringUtils.isBlank((CharSequence)password)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)domainName)) {
            domainName = rootPath;
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            title = "%s\u63a5\u53e3\u6587\u6863";
        }
        Long parentPageId = Long.valueOf(parentPageIdStr);
        Map<String, String> mdMap = this.doGenerateDoc(analyResult);
        String fdomainName = domainName;
        String ftitle = title;
        HashMap params = Maps.newHashMap();
        mdMap.entrySet().forEach(entry -> {
            params.put("bizDomain", entry.getKey());
            String pageTitle = StringUtil.procTemp(ftitle, params);
            String context = MarkDown2HtmlUtils.markdown2Html((String)entry.getValue());
            String menu = String.format("<p><img class=\"editor-inline-macro\" data-macro-name=\"toc\" data-macro-schema-version=\"1\" src=\"%s/plugins/servlet/confluence/placeholder/macro?definition=e3RvY30&amp;locale=zh_CN&amp;version=2\"></img></p>\n", fdomainName);
            WikiUtils.PageInfo pageInfo = WikiUtils.getPageIdByTitle(fdomainName, pageTitle, parentPageId, userName, password);
            if (null == pageInfo) {
                WikiUtils.createNewPage(fdomainName, pageTitle, menu + context, spaceKey, parentPageId, userName, password);
            } else {
                WikiUtils.updatePageContext(fdomainName, pageTitle, menu + context, spaceKey, pageInfo.getId(), pageInfo.getVersion() + 1, userName, password);
            }
        });
    }

    static {
        try {
            GeneratorManager.getManager().registGenerator((IGenerator)WikiGenerator.class.newInstance());
            log.info("\u6ce8\u518c\u6210\u529f");
        }
        catch (Throwable e) {
            log.error("regist error", e);
        }
    }
}

