package com.iplatform.api;

import com.iplatform.base.SystemController;
import com.iplatform.base.cache.DictCacheProvider;
import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_host;
import com.walker.cache.CacheProvider;
import com.walker.cache.SimpleCacheManager;
import com.walker.cache.tree.CacheTreeNode;
import com.walker.web.ResponseValue;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.List;

@RestController
@RequestMapping("/test/cache")
public class TestCacheApi extends SystemController {

//    @RequestMapping("/city_cache")
//    public ResponseValue testCityCache(){
//        CityCacheProvider cityCacheProvider = BeanContextAware.getBeanByType(CityCacheProvider.class);
//        List<CityTreeVo> list = cityCacheProvider.getTree();
//        if(!StringUtils.isEmptyList(list)){
//            logger.info("城市区域树根（省份）节点数量：" + list.size());
//            for(CityTreeVo vo : list){
//                logger.info(".......... " + vo.getRegionName() + ": children = " + vo.getChild().size());
//            }
//        }
//        return ResponseValue.success();
//    }
//
//    @RequestMapping("/product_attr_del")
//    public ResponseValue testRemoveProductAttr(String key, String attrId){
//        ProductAttrServiceImpl productAttrService = BeanContextAware.getBeanByType(ProductAttrServiceImpl.class);
//        ProductAttrCache cache = BeanContextAware.getBeanByType(ProductAttrCache.class);
////        String[] typeAndProductId = ProductAttrUtils.splitTypeAndProductId(key);
//        EbProductAttr productAttr = productAttrService.get(new EbProductAttr(Integer.parseInt(attrId)));
//        cache.removeList(key, productAttr);
//        logger.info("删除一个缓存，key={}, list={}", key, cache.getList(key));
//        return ResponseValue.success();
//    }
//
//    @RequestMapping("/product_attr")
//    public ResponseValue testProductAttrCache(String key){
//        ProductAttrCache cache = BeanContextAware.getBeanByType(ProductAttrCache.class);
//        List<EbProductAttr> list = cache.getList(key);
//        logger.info("获取一次缓存，key = {}, list = {}", key, list);
//        return ResponseValue.success();
//    }

    @RequestMapping("/dict")
    public ResponseValue testDictTreeCache(){
        DictCacheProvider dictCacheProvider = (DictCacheProvider)SimpleCacheManager.getCacheProvider(S_dict_data.class);
//        S_dict_data data = dictCacheProvider.getCacheData("1010010010202");
//        logger.debug("获得字典数据项: " + data.getDict_label());
//        dictCacheProvider.removeCacheData("1010010010202");
        CacheTreeNode treeNode = dictCacheProvider.get("101001");
        logger.debug("treeNode = {}, 子节点共 = {}", treeNode.getText(), treeNode.getChildren());
        dictCacheProvider.removeCacheData("101001");

        S_dict_data data = dictCacheProvider.getCacheData("101001001");
        if(data != null){
            logger.debug("父节点删除了，但子节点还在：{}", data.getDict_label());
        }
        return ResponseValue.success("删除后，获得结果：", dictCacheProvider.getCacheData("101001"));
    }

    @RequestMapping("/access")
    public ResponseValue testPermitNotLoginAccess(){
        return ResponseValue.success();
    }

    @RequestMapping("/dict_tree")
    public ResponseValue acquireDictTree(){
        DictCacheProvider dictCacheProvider = (DictCacheProvider)SimpleCacheManager.getCacheProvider(S_dict_data.class);
        List<CacheTreeNode> list01 = dictCacheProvider.getCodeList(new String[]{"101001001", "101002"});
        for(CacheTreeNode node : list01){
            logger.debug(node.getText());
        }
        logger.info("-----------------------------");

        // 返回代码字典下第一级集合
        List<S_dict_data> list02 = dictCacheProvider.getRootChildrenOneLevelList("101");
        for(S_dict_data dict_data : list02){
            logger.debug(dict_data.getDict_label());
        }
        logger.info("-----------------------------");

        // 返回 题库一级（历史） 下面所有代码树
        List<CacheTreeNode> list03 = dictCacheProvider.getCodeChildrenTreeList("101002");
        for(CacheTreeNode node : list03){
            this.printRecursion(node);
        }
        logger.info("-----------------------------");
        return ResponseValue.success();
    }

    private String printRecursion(CacheTreeNode node){
        logger.debug(node.getText());
        Collection<CacheTreeNode> child = node.getChildren();
        if(child == null || child.size() == 0){
            return null;
        }
        String success = null;
        for(CacheTreeNode n : child){
            success = printRecursion(n);
            if(success == null){
                continue;
            }
        }
        return null;
    }

    /**
     *
     * @param id 主键1可以测试
     * @return
     */
    @RequestMapping("/get_host")
    public String testGetCacheHost(String id){
        S_host host = this.getHostCacheProvider().getCacheData(id);
        if(host == null){
            return "没找到缓存host: " + id;
        } else {
            return "找到缓存host: " + host;
        }
    }

    protected CacheProvider<S_host> getHostCacheProvider(){
        return SimpleCacheManager.getCacheProvider(S_host.class);
    }
}
