package com.iplatform.api;

import com.iplatform.base.service.DataImportServiceImpl;
import com.iplatform.di.TestUserDataImportor;
import com.walker.di.DataImportException;
import com.walker.di.UpdateType;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;

@RestController
@RequestMapping("/test/di")
public class TestDataImport {

    private DataImportServiceImpl dataImportService;

    @Autowired
    public TestDataImport(DataImportServiceImpl dataImportService){
        this.dataImportService = dataImportService;
    }

    @RequestMapping("/import_excel")
    public ResponseValue testImportExcel(String fileName){
        String filePath = "d:/tmp/";
        if(StringUtils.isEmpty(fileName)){
            filePath += "test_user_30.xlsx";
        } else {
            filePath += fileName;
        }
        System.out.println("导入文件:" + filePath);
//        File file = new File("d:/tmp/test_user_30.xlsx");
        File file = new File(filePath);
        if(!file.exists()){
            return ResponseValue.error("文件不存在");
        }
        TestUserDataImportor testUserDataImportor = new TestUserDataImportor(file);
        testUserDataImportor.setId("1234567");
        testUserDataImportor.setHeadRowNumber(2);
        testUserDataImportor.setUpdateType(UpdateType.Override);
        testUserDataImportor.setSaveSizeOnce(5);
        testUserDataImportor.setSaveFileFolder("d:/tmp/");
//        userDataImportor.setDataImportService(this.dataImportService);
        try {
            testUserDataImportor.load();
            long successSize = testUserDataImportor.getSuccessSize();
            return ResponseValue.success("成功导入:" + successSize);
        } catch (DataImportException e) {
            e.printStackTrace();
            return ResponseValue.error(e.getMessage());
        }
    }

    @RequestMapping("/import_user")
    public ResponseValue testImportUser(){
        File file = new File("d:/tmp/test_user_2200.csv");
        if(!file.exists()){
            return ResponseValue.error("文件不存在");
        }
        TestUserDataImportor testUserDataImportor = new TestUserDataImportor(file);
//        userDataImportor.setDataImportService(this.dataImportService);
        try {
            testUserDataImportor.load();
            long successSize = testUserDataImportor.getSuccessSize();
            return ResponseValue.success("成功导入:" + successSize);
        } catch (DataImportException e) {
            e.printStackTrace();
            return ResponseValue.error(e.getMessage());
        }
    }
}
