//package com.iplatform.api;
//
//import com.iplatform.base.service.CodeServiceImpl;
//import com.iplatform.gather.LocalAddress;
//import com.iplatform.gather.SingleTableGatherScheduler;
//import com.iplatform.gather.TestFileTableScheduler;
//import com.iplatform.gather.support.DefaultDatabaseStore;
//import com.iplatform.model.po.S_code;
//import com.iplatform.model.po.S_scheduler;
//import com.iplatform.scheduler.PlatformSchedulerManager;
//import com.iplatform.scheduler.service.SchedulerServiceImpl;
//import com.walker.connector.Address;
//import com.walker.db.DatabaseType;
//import com.walker.db.page.GenericPager;
//import com.walker.db.page.ListPageContext;
//import com.walker.infrastructure.utils.StringUtils;
//import com.walker.store.AbstractMetaDataEngine;
//import com.walker.store.repo.DatabaseRepository;
//import com.walker.store.strategy.SingleDatabaseTableStrategy;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//import java.util.ArrayList;
//import java.util.List;
//
//@RestController
//@RequestMapping("/test/scheduler")
//public class TestSchedulerApi {
//
//    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
//
//    private SchedulerServiceImpl schedulerService;
//
//    private PlatformSchedulerManager schedulerManager;
//
//    private AbstractMetaDataEngine metaDataEngine;
//
//    private LocalAddress localAddress;
//
//    @Autowired
//    private CodeServiceImpl codeService;
//
//    @Autowired
//    public TestSchedulerApi(SchedulerServiceImpl service
//            , PlatformSchedulerManager schedulerManager, AbstractMetaDataEngine metaDataEngine, LocalAddress localAddress){
//        this.schedulerService = service;
//        this.schedulerManager = schedulerManager;
//        this.metaDataEngine = metaDataEngine;
//        this.localAddress = localAddress;
//    }
//
//    @RequestMapping("/list_code")
//    public String testPageInfo(int pageIndex){
//        ListPageContext.setCurrentPageIndex(pageIndex);
//        ListPageContext.setCurrentPageSize(5);
////        GenericPager<S_code> pager = this.codeService.selectSplit(new S_code(), null, null);
//        GenericPager<S_code> pager = this.codeService.selectSplit("select * from s_code order by id asc", new Object[]{}, new S_code());
//        List<S_code> list = pager.getDatas();
//        logger.info("-----------------> s_code list, page = " + pageIndex);
//        logger.info("getFirstRowIndex = " + pager.getFirstRowIndexInPage() + ", getEndRowIndex = " + pager.getEndRowIndexPage());
//        if(!StringUtils.isEmptyList(list)){
//            for(S_code e : list){
//                logger.info(e.toString());
//            }
//        }
//        return "ok";
//    }
//
//    @RequestMapping("/test_create_scheduler")
//    public String testCreateScheduler() {
//        logger.info("--------> 创建调度器");
//        String storeId = "test_store";
//
//        List<Address> addressList = new ArrayList<>(2);
//        addressList.add(this.localAddress);
//
//        DatabaseRepository repository = new DatabaseRepository();
//        repository.setId(storeId);
//        repository.setDefineName("yunjing");
//        repository.setAddressList(addressList);
//
//        TestTableStrategy tableStrategy = new TestTableStrategy();
//        tableStrategy.setMetaDataEngine(this.metaDataEngine);
//        tableStrategy.setStoreId(storeId);
//        tableStrategy.setRepository(repository);
//
//        DefaultDatabaseStore databaseStore = new DefaultDatabaseStore();
//        databaseStore.setId(storeId);
//        databaseStore.setDatabaseType(DatabaseType.MYSQL);
//        databaseStore.setSupportUpdate(false);
//        databaseStore.setMetaDataEngine(this.metaDataEngine);
//        databaseStore.setStoreStrategy(tableStrategy);
//        databaseStore.initialize();
//
//        SingleTableGatherScheduler scheduler = new TestFileTableScheduler(999, "测试单表调度器", databaseStore);
//        scheduler.setTimeInterval(5000);
//        scheduler.setScheduleEngine(this.schedulerManager.getScheduleEngine());
//        scheduler.setAllowIdleSleep(true);
//
//        this.schedulerManager.startScheduler(scheduler);
//        return "scheduler started! name=" + scheduler.getName();
//    }
//
//    @RequestMapping("/test_transaction")
//    public String testTransaction(){
//        this.schedulerService.execTestTransaction(true);
//        return "数据都不能更新，id=1、2，请检查";
//    }
//
//    @RequestMapping("/query_split")
//    public String querySplit(int page){
////        SplitPageInfo splitPageInfo = new DefaultSplitPageInfo();
////        splitPageInfo.setCurrentPage(page);
//        GenericPager<S_scheduler> pager = this.schedulerService.queryPageSchedulerList(-1);
//        this.printList(pager.getDatas());
//        return "ok";
//    }
//
//    @RequestMapping("/query_running")
//    public String queryRunning(){
//        List<S_scheduler> data = this.schedulerService.queryRunningSchedulers();
//        this.printList(data);
//        return "ok";
//    }
//
//    @RequestMapping("/task_start")
//    public String updateStart(int id){
//        this.schedulerService.execUpdateSchedulerStarted(id);
//        return "started!";
//    }
//
//    private void printList(List<S_scheduler> data){
//        if(!StringUtils.isEmptyList(data)){
//            for(S_scheduler e : data){
//                logger.info(e.toString());
//            }
//        }
//    }
//
//    private class TestTableStrategy extends SingleDatabaseTableStrategy{
//        @Override
//        protected String doQueryTableName(Address address, String srcTable, Object parameter) {
//            // 获得当前日期，把表名拼上日期
//            return srcTable + StringUtils.UNDERLINE + "test";
//        }
//    }
//}
