package com.iplatform.api;

import com.iplatform.base.PushController;
import com.iplatform.base.PushData;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.model.po.S_chat;
import com.iplatform.model.po.S_user_core;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.web.ResponseValue;
import com.walker.web.WebRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.parameters.P;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@RestController
@RequestMapping("/test/web")
public class TestWebController extends PushController {

//    private SchedulerServiceImpl schedulerService;
    private JdbcTemplate jdbcTemplate;
    private UserServiceImpl userService;

    @Autowired
    public TestWebController(JdbcTemplate jdbcTemplate, UserServiceImpl userService){
//        this.schedulerService = schedulerService;
        this.jdbcTemplate = jdbcTemplate;
        this.userService = userService;
    }

    @RequestMapping("/batch_insert")
    public ResponseValue batchInsert(){
        List<S_chat> poList = new ArrayList<>(8);
        int i = 1;
        poList.add(this.acquireChatData("测试消息"+ ++i, "type" + ++i, "chat"));
        poList.add(this.acquireChatData("测试消息"+ ++i, "type" + ++i, "chat"));
        poList.add(this.acquireChatData("测试消息"+ ++i, "type" + ++i, "chat"));
        this.userService.insertBatch(poList);
        return ResponseValue.success();
    }

    private S_chat acquireChatData(String msg, String bizId, String msgType){
        S_chat chat = new S_chat();
        chat.setId(NumberGenerator.getLongSequenceNumber());
        chat.setCreate_time(DateUtils.getDateTimeNumber());
        chat.setMe(0L);
        chat.setType(1);
        chat.setMessage(msg);
        chat.setUser_id(1L);
        chat.setBiz_id(bizId);
        chat.setMsg_type(msgType);
        return chat;
    }

    @RequestMapping("/push_msg")
    public ResponseValue testPushMessage() throws Exception{

        PushData pushData = new PushData();
        pushData.setTitle("审批文件事项");
        pushData.setBusinessType("001");
        pushData.setBusinessId("123456789");
        pushData.setUserId("1");    // shikeying

        this.pushMessageNotification(pushData);
        logger.info("----------- 'msg' end -----------");

        TimeUnit.SECONDS.sleep(2);

        this.pushMailNotification("测试标题", "你好！这是一个邮件信息", "1");
        logger.info("----------- 'mail' end -----------");
        return ResponseValue.success();
    }

    @Transactional
    @RequestMapping("/rollback")
    public ResponseValue<String> testTransactionRollback(String error){
        // 更新记录: 1
        this.jdbcTemplate.execute("update s_scheduler set status=2 where id=1");
        if(error != null && error.equals("true")){
            throw new WebRuntimeException("业务异常，回滚", "data");
        }
        // 更新记录: 2
        this.jdbcTemplate.execute("update s_scheduler set status=2 where id=2");
        return ResponseValue.success();
    }

    @RequestMapping("/po")
    public ResponseValue testPoJson() throws Exception{
        S_user_core user_core = new S_user_core();
        user_core.setId(123L);
        user_core.setUser_name("时克英");
        user_core.setUpdate_time(20230324103901L);
        String json = JsonUtils.objectToJsonString(user_core);
//        JsonUtils
        return ResponseValue.success(json);
    }

    @RequestMapping("/jdbc")
    public ResponseValue testJdbc(){

        // 批量添加
//        List<S_user_core> user_coreList = new ArrayList<>(8);
//        user_coreList.add(this.createOneUser(100));
//        user_coreList.add(this.createOneUser(101));
//        user_coreList.add(this.createOneUser(102));
//        int success = this.userService.insertBatch(user_coreList);
//        System.out.println("--------> 批量写入新用户: " + success);
//
//        List<S_user_core> editList = new ArrayList<>(4);
//        S_user_core edit100 = new S_user_core();
//        edit100.setId(100L);
//        edit100.setNick_name("修改名字100");
//        S_user_core edit101 = new S_user_core();
//        edit101.setId(101L);
//        edit101.setNick_name("修改名字101");
//        editList.add(edit100);
//        editList.add(edit101);
//        success = this.userService.updateBatch(editList);
//        System.out.println("--------> 批量更新用户（相同属性）: " + success);

        S_user_core selectPo = new S_user_core();
        selectPo.setStatus(0);
        selectPo.setDept_id(1670057808440L);
//        selectPo.setUser_name("login_%");
        selectPo.setUser_name("13838277463");
        List<S_user_core> list = this.userService.select(selectPo);
        if(list != null){
            for(S_user_core user : list){
                System.out.println(user);
            }
        }
        System.out.println("--------> 搜索用户集合: ");

        S_user_core userPo = new S_user_core();
        userPo.setUser_type(2);
//        userPo.setDept_id(1670057686025L);
        GenericPager<S_user_core> pager = this.userService.selectSplit(userPo, 2, 6);
        for(S_user_core s : pager.getDatas()){
            System.out.println("------- 用户:" + s.getNick_name());
        }
        return ResponseValue.success();
    }

    private S_user_core createOneUser(long id){
        S_user_core user = new S_user_core();
        user.setId(id);
        user.setCreate_by("insertBatch");
        user.setCreate_time(DateUtils.getDateTimeNumber());
        user.setUser_name("login_" + id);
        user.setNick_name("姓名_" + id);
        user.setUser_type(2);
        user.setOrg_id(1670031584892L);
        user.setDept_id(1670057808440L);
        user.setPassword("$2a$10$9lSwwUFMULR6/KhPsUbTj.0PTZfTnq0fB3OtS6PWoKAibpa8hL1cy");
        return user;
    }
}
