package com.iplatform.di;

import com.iplatform.base.di.JdbcExcelDataImportor;
import com.iplatform.base.util.DataImportUtils;
import com.walker.di.UpdateResult;
import com.walker.di.UpdateType;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TestUserDataImportor extends JdbcExcelDataImportor {

    public TestUserDataImportor(File file){
        this.setBatchEnabled();
//        this.setIgnoreRows(1);
        this.setBatchSleepMills(500);
        try {
            this.setSource(new BufferedInputStream(new FileInputStream(file)));
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String acquireTableName() {
        return "test_user";
    }

    @Override
    protected boolean isCheckDataExist() {
        return true;
    }

    @Override
    protected UpdateResult checkDataExist(String tableName, List<Map<String, Object>> mapList) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        List<String> paramCardNo = DataImportUtils.acquireWhereInStringValues("CARD_NO", mapList);
        List<String> paramPhone = DataImportUtils.acquireWhereInStringValues("PHONE", mapList);
        sqlParameterSource.addValue("cardNo", paramCardNo);
        sqlParameterSource.addValue("phone", paramPhone);
        List<Map<String, Object>> existList = this.getDataImportService().queryListObjectWhereIn(SQL_QUERY, sqlParameterSource);
        if(!StringUtils.isEmptyList(existList)){
            for(Map<String, Object> existOne : existList){
                logger.debug("存在一条数据 = " + existOne);
            }
        }

        UpdateResult updateResult = new UpdateResult();
        List<String> whereColumnNames = Arrays.asList("CARD_NO", "PHONE");

        // 找到新写入的数据集合
//        List<Map<String, Object>> insertList = DataImportUtils.calculateInsertList(mapList, existList, whereColumnNames);
        Object[] result = DataImportUtils.calculateInsertAndUpdateList(mapList, existList, whereColumnNames);
        List<Map<String, Object>> insertList = (List<Map<String, Object>>)result[0];
        List<Map<String, Object>> updateList = (List<Map<String, Object>>)result[1];

        if(!StringUtils.isEmptyList(insertList)){
            logger.debug("找到写入集合数量:" + insertList.size());
            for(Map<String, Object> existOne : insertList){
                logger.debug("新写入一条数据 = " + existOne);
            }
        }
        updateResult.setInsertList(insertList);

        if(this.getUpdateType() == UpdateType.Override){
            // 如果更新数据策略为: 覆盖模式，需要批量更新数据，这里获得更新集合给平台。
            updateResult.setUpdateColumnNames(Arrays.asList("THIRD_PARTY_NO", "THIRD_PARTY_NAME", "CUSTOMER_NAME"));
            updateResult.setWhereColumnNames(whereColumnNames);
            updateResult.setUpdateList(updateList);
        }
        return updateResult;
    }

    @Override
    protected String validateData(Map<String, String> map) {
        String phoneNumber = map.get("PHONE");
        if(StringUtils.isEmpty(phoneNumber) || !PhoneNumberUtils.isCellPhoneNumber(phoneNumber)){
            return "手机号格式错误";
        }
        return null;
    }

    private static final String SQL_QUERY = "select * from test_user where CARD_NO in (:cardNo) and PHONE in (:phone)";
}
