package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.dict.DictParam;
import com.iplatform.base.service.CodeServiceImpl;
import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_dict_type;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/system/dict")
public class CodeController extends SystemController {

    private CodeServiceImpl codeService;

    @Autowired
    public CodeController(CodeServiceImpl codeService){
        this.codeService = codeService;
    }

    @RequestMapping("/type/list")
    public ResponseValue listType(DictParam dictParam){
        logger.debug(dictParam.toString());
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        // 需要添加拦截器，统一销毁线程变量对象，马上要补充，2022-11-19
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//        this.preparePageSearch();

        long beginTime = -1;
        long endTime = -1;
        if(dictParam.getParams().get("beginTime") != null){
            beginTime = this.getParamsDateTime(dictParam.getParams().get("beginTime").toString(), false);
        }
        if(dictParam.getParams().get("endTime") != null){
            endTime = this.getParamsDateTime(dictParam.getParams().get("endTime").toString(), false);
        }
        logger.debug("beginTime = " + beginTime + ", endTime = " + endTime);

        GenericPager<S_dict_type> pager = this.codeService.queryPageDictType(dictParam.getDictName()
                , dictParam.getDictType(), dictParam.getStatus(), beginTime, endTime);
//        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
        return ResponseValue.success(pager);
    }

    @RequestMapping("/type/{dictId}")
    public ResponseValue detailDictType(@PathVariable Long dictId){
        if(dictId == null || dictId.longValue() <= 0){
            return ResponseValue.error("字典id错误");
        }
        return ResponseValue.success(this.codeService.queryOneDictType(dictId));
    }

    /**
     * 在数据字典项管理界面，查询条件展示所有'字典类型'列表。<p></p>
     * 因为权限配置的是: /system/dict/data/** 开放，因此该权限也配置到data，否则还需要再加上一个权限点。
     * @return
     * @date 2022-11-19
     */
//    @GetMapping("/type/optionselect")
    @GetMapping("/data/optionselect")
    public ResponseValue showDictTypeListAll(){
        List<S_dict_type> list = this.codeService.selectAll(new S_dict_type());
        return ResponseValue.success(list);
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`

    /**
     * 根据代码表名字，查询包含的代码项集合。
     * @param dictType
     * @return
     */
    @RequestMapping("/data/type/{dictType}")
    public ResponseValue<List<S_dict_data>> dictTypeList(@PathVariable String dictType){
        logger.debug("dictType = " + dictType);
        List<S_dict_data> list = this.codeService.queryDictDataByType(dictType);
        if(StringUtils.isEmptyList(list)){
            list = new ArrayList<S_dict_data>(2);
        }
        return ResponseValue.success(list);
    }

    @RequestMapping("/data/list")
    public ResponseValue listData(DictParam dictParam){
//        this.preparePageSearch();
        if(StringUtils.isEmpty(dictParam.getDictType())){
            return ResponseValue.error("必须提供字典类型参数");
        }
        GenericPager<S_dict_data> pager = this.codeService.queryPageDictData(dictParam.getDictType(), dictParam.getDictLabel());
//        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
        return ResponseValue.success(pager);
    }

    @RequestMapping("/add")
    public ResponseValue insertDictData(@RequestBody S_dict_data s_dict_data){
        logger.debug(s_dict_data.toString());
        if(s_dict_data.getDict_code() == null){
            return ResponseValue.error("字典id必须输入!");
        }
        if(s_dict_data.getParent_id() == null){
            return ResponseValue.error("父id必须输入!");
        }
        S_dict_data dict_data = this.getDictCacheProvider().getCacheData(String.valueOf(s_dict_data.getDict_code()));
        if(dict_data != null){
            return ResponseValue.error("字典id已存在!");
        }
        String error = this.validateDictData(s_dict_data, true);
        if(error != null){
            return ResponseValue.error(error);
        }

        if(StringUtils.isEmpty(s_dict_data.getDict_value())){
            // 字典值如果不填，必须和id一致
            s_dict_data.setDict_value(String.valueOf(s_dict_data.getDict_code()));
        }
//        s_dict_data.setDict_code(NumberGenerator.getSequenceNumber());
        s_dict_data.setCreate_time(DateUtils.getDateTimeNumber(System.currentTimeMillis()));

        this.codeService.insert(s_dict_data);
        this.getDictCacheProvider().putCacheData(String.valueOf(s_dict_data.getDict_code()), s_dict_data);
        return ResponseValue.success();
    }

    @RequestMapping("/data/{dictCode}")
    public ResponseValue getDictDataInfo(@PathVariable Long dictCode){
        S_dict_data e = this.codeService.queryOneDictData(dictCode);
        return ResponseValue.success(e);
    }

    @RequestMapping("/edit")
    public ResponseValue updateDictData(@RequestBody S_dict_data s_dict_data){
        String error = this.validateDictData(s_dict_data, false);
        if(error != null){
            return ResponseValue.error(error);
        }
        this.codeService.save(s_dict_data);
        this.getDictCacheProvider().updateCacheData(String.valueOf(s_dict_data.getDict_code()), s_dict_data);
        return ResponseValue.success();
    }

    @RequestMapping("/data/remove/{dictCodes}")
    public ResponseValue removeDictData(@PathVariable Long[] dictCodes){
        if(dictCodes == null){
            return ResponseValue.error("没有字典参数");
        }
        this.codeService.execDeleteDictData(dictCodes);
        for(long code : dictCodes){
            this.getDictCacheProvider().removeCacheData(String.valueOf(code));
        }
        return ResponseValue.success();
    }

    private String validateDictData(S_dict_data s_dict_data, boolean checkExist){
        if(s_dict_data == null){
            return "提交字典内容为空";
        }
        if(StringUtils.isEmpty(s_dict_data.getDict_type())){
            return "请选择字典类型";
        }
        if(StringUtils.isEmpty(s_dict_data.getDict_label())){
            return "请输入字典标签";
        }
//        if(StringUtils.isEmpty(s_dict_data.getDict_value())){
//            return "请输入字典值";
//        }

        if(checkExist){
            S_dict_data exist = this.codeService.queryOneDictData(s_dict_data.getDict_type(), s_dict_data.getDict_value());
            if(exist != null){
                return "已经存在该字典值，请重新输入";
            }
        }
        return null;
    }
}
