package com.iplatform.base.controller;

import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.pojo.KeywordsParam;
import com.iplatform.base.pojo.form.RequestForm;
import com.iplatform.base.service.ConfigFormServiceImpl;
import com.iplatform.model.po.S_config_form;
import com.iplatform.model.vo.ConfigFormVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 配置表单管理功能。
 * @author 时克英
 * @date 2023-05-16
 */
@RestController
@RequestMapping("/system/form")
public class ConfigFormController extends PlatformAdapterController {

    private ConfigFormServiceImpl configFormService;
    private FormCacheProvider formCacheProvider;

    @Autowired
    public ConfigFormController(ConfigFormServiceImpl configFormService, FormCacheProvider formCacheProvider){
        this.configFormService = configFormService;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue edit(@RequestParam Integer id, @RequestBody RequestForm requestForm){
        if(requestForm == null || StringUtils.isEmpty(requestForm.getContent()) || id == null){
            return ResponseValue.error("参数错误");
        }

        try {
            JsonUtils.jsonStringToObject(requestForm.getContent(), ConfigFormVo.class);
            S_config_form form = this.acquireConfigForm(requestForm, id);
            this.configFormService.save(form);
            this.formCacheProvider.updateCacheData(String.valueOf(form.getId()), form);
            logger.info("编辑表单模板成功：" + requestForm.getName());

        } catch (Exception e) {
            logger.error(requestForm.getContent());
            throw new PlatformRuntimeException("更新表单模板格式不正确:" + e.getMessage(), e);
        }
        return ResponseValue.success();
    }

    /**
     * 保存新创建表单模板。
     * @param requestForm
     * @return
     * @date 2023-05-23
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseValue add(@RequestBody RequestForm requestForm){
        if(requestForm == null || StringUtils.isEmpty(requestForm.getContent())){
            return ResponseValue.error("参数错误");
        }
        try {
            JsonUtils.jsonStringToObject(requestForm.getContent(), ConfigFormVo.class);
//            S_config_form form = new S_config_form();
//            form.setName(requestForm.getName());
//            form.setInfo(requestForm.getInfo());
//            form.setContent(requestForm.getContent());
//            form.setCreate_time(DateUtils.getDateTimeNumber());
//            form.setUpdate_time(form.getCreate_time());
//            form.setId(this.configFormService.queryNextId());
            S_config_form form = this.acquireConfigForm(requestForm, this.configFormService.queryNextId());
            this.configFormService.insert(form);
            this.formCacheProvider.putCacheData(String.valueOf(form.getId()), form);
            logger.info("创建表单模板成功：" + requestForm.getName());

        } catch (Exception e) {
            logger.error(requestForm.getContent());
            throw new PlatformRuntimeException("创建的表单模板格式不正确:" + e.getMessage(), e);
        }
        return ResponseValue.success();
    }

    private S_config_form acquireConfigForm(RequestForm requestForm, int id){
        S_config_form form = new S_config_form();
        form.setName(requestForm.getName());
        form.setInfo(requestForm.getInfo());
        form.setContent(requestForm.getContent());
        form.setCreate_time(DateUtils.getDateTimeNumber());
        form.setUpdate_time(form.getCreate_time());
        form.setId(id);
        return form;
    }

    @RequestMapping(value = "/info", method = RequestMethod.GET)
    public ResponseValue info(@RequestParam(value = "id") Integer id){
//        S_config_form form = this.configFormService.get(new S_config_form(id));
        if(id == null || id.intValue() <= 0){
            return ResponseValue.error();
        }
        S_config_form form = this.formCacheProvider.getCacheData(id.toString());
        if(form == null){
            return ResponseValue.error("表单不存在, id=" + id);
        }
        return ResponseValue.success(form);
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(KeywordsParam keywordsParam){
        String keywords = null;
        if(keywordsParam != null && StringUtils.isNotEmpty(keywordsParam.getKeywords())){
            keywords = UrlUtils.decode(keywordsParam.getKeywords());
        }
        GenericPager<S_config_form> pager = this.configFormService.queryPageFormList(keywords);
        return ResponseValue.success(pager);
    }
}
