package com.iplatform.base.controller;

import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.pojo.GroupDataParam;
import com.iplatform.base.pojo.KeywordsParam;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.group.GroupData;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 平台分组数据管理。
 * <p>实现配置功能块能包含哪些内容项，如：手机首页导航栏可配置等。</p>
 * @author 时克英
 * @date 2023-05-20
 */
@RestController
@RequestMapping("/system/group")
public class GroupController extends PlatformAdapterController {

    @Autowired
    public GroupController(GroupServiceImpl groupService, FormCacheProvider formCacheProvider){
        this.groupService = groupService;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResponseValue updateGroup(
//            @RequestParam Integer id,
            @RequestBody S_group group){
        if(group == null || StringUtils.isEmpty(group.getName()) || group.getId() == null){
            return ResponseValue.error("参数错误");
        }
//        group.setId(id);
        group.setUpdate_time(DateUtils.getDateTimeNumber());
        this.groupService.save(group);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    public ResponseValue deleteGroup(Integer id){
        if(id == null){throw new IllegalArgumentException("缺少参数");}
        S_group_data groupData = new S_group_data();
        groupData.setGid(id);
        List<S_group_data> groupDataList = this.groupService.select(groupData);
        if(!StringUtils.isEmptyList(groupDataList)){
            return ResponseValue.error("分组下存在数据项，无法删除!");
        }
        this.groupService.delete(new S_group(id));
        return ResponseValue.success();
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public ResponseValue saveGroup(@RequestBody S_group group){
        if(group == null){
            return ResponseValue.error("参数错误");
        }
        group.setCreate_time(DateUtils.getDateTimeNumber());
        group.setUpdate_time(group.getCreate_time());
        group.setId(this.groupService.queryGroupNextId());
        this.groupService.insert(group);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/data/delete", method = RequestMethod.GET)
    public ResponseValue deleteData(@RequestParam(value = "id") Integer id){
        this.groupService.delete(new S_group_data(id));
        return ResponseValue.success();
    }

    @RequestMapping(value = "/data/update", method = RequestMethod.POST)
    public ResponseValue updateData(@RequestParam Integer id, @RequestBody GroupData groupData){
        if(groupData == null || id == null){
            return ResponseValue.error("参数错误");
        }

        String value = this.acquireFormValue(groupData.getForm());

        S_group_data group_data = new S_group_data();
        group_data.setGid(groupData.getGid());
        group_data.setValue(this.clearCdnPrefix(value));
        group_data.setSort(groupData.getForm().getSort());
        group_data.setStatus(groupData.getForm().getStatus());
        group_data.setUpdate_time(group_data.getCreate_time());
        group_data.setId(id);
        this.groupService.save(group_data);
        return ResponseValue.success();
    }

//    @ApiOperation(value = "新增:分组列表项")
    @RequestMapping(value = "/data/save", method = RequestMethod.POST)
    public ResponseValue saveData(@RequestBody GroupData groupData){
        if(groupData == null){
            return ResponseValue.error("参数错误");
        }
        String value = this.acquireFormValue(groupData.getForm());
        int nextId = this.groupService.queryGroupDataNextId();

        S_group_data group_data = new S_group_data();
        group_data.setGid(groupData.getGid());
        group_data.setValue(this.clearCdnPrefix(value));
        group_data.setSort(groupData.getForm().getSort());
        group_data.setStatus(groupData.getForm().getStatus());
        group_data.setCreate_time(DateUtils.getDateTimeNumber());
        group_data.setUpdate_time(group_data.getCreate_time());
        group_data.setId(nextId);
        this.groupService.insert(group_data);
        return ResponseValue.success();
    }

    private String acquireFormValue(FormData formData){
        this.formCacheProvider.validateForm(formData);
        try {
            return JsonUtils.objectToJsonString(formData);
        } catch (Exception e) {
            throw new PlatformRuntimeException("转换Json字符串失败：" + formData.getId(), e);
        }
    }

    @RequestMapping(value = "/data/list", method = RequestMethod.GET)
    public ResponseValue listData(GroupDataParam groupDataParam){
        if(groupDataParam == null || groupDataParam.getGid() == null){
            throw new IllegalArgumentException("参数错误:groupDataParam");
        }
        GenericPager<S_group_data> pager = this.groupService.queryPageGroupDataList(groupDataParam.getGid(), groupDataParam.getStatus());
        pager.getDatas().stream().forEach(data -> {
            try {
                // 把value转成Json，重新格式化一遍，返回前端。
                FormData formData = JsonUtils.jsonStringToObject(data.getValue(), FormData.class);
                data.setValue(JsonUtils.objectToJsonString(formData));
                logger.info(data.getValue());
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return ResponseValue.success(pager);
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(KeywordsParam keywordsParam){
        String keywords = null;
        if(keywordsParam != null && StringUtils.isNotEmpty(keywordsParam.getKeywords())){
            keywords = UrlUtils.decode(keywordsParam.getKeywords());
        }
        GenericPager<S_group> pager = this.groupService.queryPageGroupList(keywords);
        return ResponseValue.success(pager);
    }

    private GroupServiceImpl groupService;
    private FormCacheProvider formCacheProvider;
}
