package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.log.LoginLogParam;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.model.po.S_login_info;
import com.walker.db.page.GenericPager;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 登录日志查询。
 * @date 2023-01-04
 */
@RestController
@RequestMapping("/monitor/login_info")
public class LoginInfoController extends SystemController {

    private LogServiceImpl logService;

    @Autowired
    public LoginInfoController(LogServiceImpl logService){
        this.logService = logService;
    }

    @RequestMapping("/select/clean")
    public ResponseValue clear(){
        this.logService.execClearLoginLog();
        return ResponseValue.success();
    }

    @RequestMapping("/list")
    public ResponseValue list(LoginLogParam loginLogParam){
//        this.preparePageSearch();
        GenericPager<S_login_info> pager = null;
        if(loginLogParam == null){
            pager = this.logService.queryPageLoginLogList(null, null, null);
        } else {
            pager = this.logService.queryPageLoginLogList(loginLogParam.getIpaddr()
                    , loginLogParam.getUserName(), loginLogParam.getStatus());
        }
//        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
        return ResponseValue.success(pager);
    }
}
