package com.iplatform.base.controller;

import com.iplatform.base.Constants;
import com.iplatform.base.NotifyConstants;
import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.notify.InfoParam;
import com.iplatform.base.pojo.notify.NotificationParam;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.model.po.SfNotification;
import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationConfigVo;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 消息通知管理，该通知仅是针对业务通知分类管理，同时能实现同步微信消息模板。
 * <pre>
 *     1)目前微信公众号消息，依赖该功能中的同步模板记录
 *     2)平台推送消息列表，请在"消息推送记录" 中查询。
 * </pre>
 * @author 时克英
 * @date 2023-08-24
 */
@RestController
@RequestMapping("/platform/system/notification")
public class NotificationController extends SystemController {

    private NotificationServiceImpl notificationService;

    @Autowired
    public NotificationController(NotificationServiceImpl notificationService){
        this.notificationService = notificationService;
    }

    @RequestMapping(value = "/sms/switch", method = RequestMethod.POST)
    public ResponseValue smsSwitch(Long id){
        SfNotification notification = this.notificationService.get(new SfNotification(id));
        if (notification.getIsSms().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error("通知没有配置短信");
        }
        if(notification.getIsSms().intValue() == NotifyConstants.SWITCH_OPEN){
            notification.setIsSms(NotifyConstants.SWITCH_COLSE);
        } else {
            notification.setIsSms(NotifyConstants.SWITCH_OPEN);
        }
        this.notificationService.update(notification);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/routine/switch", method = RequestMethod.POST)
    public ResponseValue routineSwitch(Long id){
        SfNotification notification = this.notificationService.get(new SfNotification(id));
        if (notification.getIsRoutine().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error("通知没有配置小程序订阅模板");
        }
        if(notification.getIsRoutine().intValue() == NotifyConstants.SWITCH_OPEN){
            notification.setIsRoutine(NotifyConstants.SWITCH_COLSE);
        } else {
            notification.setIsRoutine(NotifyConstants.SWITCH_OPEN);
        }
        this.notificationService.update(notification);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/wechat/switch", method = RequestMethod.POST)
    public ResponseValue wechatSwitch(Long id){
        SfNotification notification = this.notificationService.get(new SfNotification(id));
        if (notification.getIsWechat().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error("通知没有配置公众号模板");
        }
        if(notification.getIsWechat().intValue() == NotifyConstants.SWITCH_OPEN){
            notification.setIsWechat(NotifyConstants.SWITCH_COLSE);
        } else {
            notification.setIsWechat(NotifyConstants.SWITCH_OPEN);
        }
        this.notificationService.update(notification);
        return ResponseValue.success();
    }

    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    public ResponseValue detail(InfoParam request){
        if(request == null || request.getId() == null){
            return ResponseValue.error(Constants.ERROR_ARGUMENT);
        }
        long id = request.getId();
        SfNotification notification = this.notificationService.get(new SfNotification(id));
        NotificationConfigVo vo = new NotificationConfigVo();
        SfTemplateMessage templateMessage = null;

        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_WECHAT)) {
            if (notification.getIsWechat().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error("请先配置公众号模板消息");
            }
            templateMessage = this.notificationService.get(new SfTemplateMessage(notification.getWechatId().longValue()));
            vo = NotificationUtils.acquireNotificationConfigVo(templateMessage);
            vo.setStatus(notification.getIsWechat());

        } else if(request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_ROUTINE)){
            if (notification.getIsRoutine().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error("请先配置小程序订阅消息");
            }
            templateMessage = this.notificationService.get(new SfTemplateMessage(notification.getRoutineId().longValue()));
            vo = NotificationUtils.acquireNotificationConfigVo(templateMessage);
            vo.setStatus(notification.getIsRoutine());

        } else if(request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_SMS)){
            if (notification.getIsSms().intValue() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error("请先配置短信模板");
            }
            templateMessage = this.notificationService.get(new SfTemplateMessage(notification.getSmsId().longValue()));
            vo = NotificationUtils.acquireNotificationConfigVo(templateMessage);
            vo.setStatus(notification.getIsSms());
        }
        return ResponseValue.success(vo);
    }

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseValue list(NotificationParam param){
        List<SfNotification> data = null;
        if(param == null){
            data = this.notificationService.queryList(null);
        } else {
            data = this.notificationService.queryList(param.getSendType());
        }
        return ResponseValue.success(data);
    }
}
