package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.util.UserUtils;
import com.walker.cache.AbstractCacheProvider;
import com.walker.web.ResponseValue;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import com.walker.web.WebRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@RestController
@RequestMapping("/monitor/online")
public class OnlineUserController extends SystemController {

    private static final int MAX_DATA_SIZE = 64;

    private UserOnlineProvider userOnlineProvider;

    @Autowired
    public OnlineUserController(UserOnlineProvider userOnlineProvider){
        this.userOnlineProvider = userOnlineProvider;
    }

    @RequestMapping("/list")
    public ResponseValue list(){
        AbstractCacheProvider cacheProvider = (AbstractCacheProvider)this.userOnlineProvider;
        Collection<Object> list = cacheProvider.queryListLimit(MAX_DATA_SIZE);
        List<UserPrincipal> data = new ArrayList<>();
        if(list != null && list.size() > 0){
            try {
                for(Object up : list){
//                    logger.debug(up.toString());
                    data.add(UserUtils.toUserPrincipal(up.toString()));
                }
            } catch (Exception ex){
                throw new WebRuntimeException("在线用户缓存对象转换错误:");
            }
        }
        return this.acquireTablePage(data, data.size());
    }
}
