package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.log.OperateLogParam;
import com.iplatform.base.service.LogServiceImpl;
import com.iplatform.model.po.S_oper_log;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.web.ResponseValue;
import com.walker.web.log.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("/monitor/operate_log")
public class OperateLogController extends SystemController {

    private LogServiceImpl logService;

    @Autowired
    public OperateLogController(LogServiceImpl logService){
        this.logService = logService;
    }

    @RequestMapping("/select/get_business_type")
    public ResponseValue getBusinessTypeList(){
        List<KeyValue<Integer, String>> data = new ArrayList<>();
        for(BusinessType businessType : BusinessType.values()){
            data.add(new KeyValue<>(businessType.getIndex(), businessType.getName()));
        }
        return ResponseValue.success(data);
    }

    @RequestMapping("/select/clean")
    public ResponseValue clear(){
        this.logService.execClearOperateLog();
        return ResponseValue.success();
    }

    @RequestMapping("/list")
    public ResponseValue list(OperateLogParam operateLogParam){
//        this.preparePageSearch();
        GenericPager<S_oper_log> pager = null;
        if(operateLogParam == null){
            pager = this.logService.queryPageOperateLogList(null, null, null, null);
        } else {
            pager = this.logService.queryPageOperateLogList(operateLogParam.getOperName()
                    , operateLogParam.getBusinessType(), operateLogParam.getStatus(), operateLogParam.getTitile());
        }
//        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
        return ResponseValue.success(pager);
    }
}
