package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.PlatformSchedulerManager;
import com.iplatform.scheduler.pojo.SchedulerParam;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.walker.db.page.GenericPager;
import com.walker.scheduler.Scheduler;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/monitor/job")
@ConditionalOnProperty(prefix = "iplatform.scheduler", name = "enabled", havingValue = "true", matchIfMissing = true)
public class SchedulerController extends SystemController {

    private SchedulerServiceImpl schedulerService;
    private PlatformSchedulerManager platformSchedulerManager;

    @Autowired
    public SchedulerController(SchedulerServiceImpl schedulerService, PlatformSchedulerManager platformSchedulerManager){
        this.schedulerService = schedulerService;
        this.platformSchedulerManager = platformSchedulerManager;
    }

    @RequestMapping("/select/run")
    public ResponseValue run(@RequestBody S_scheduler s_scheduler){
        if(this.platformSchedulerManager == null){
            return ResponseValue.error("调度模块未开启配置");
        }
        if(s_scheduler == null){
            return ResponseValue.error("调度任务不存在");
        }
        Scheduler scheduler = this.platformSchedulerManager.getOneGatherScheduler(s_scheduler.getId());
        if(scheduler == null){
            return ResponseValue.error("调度器不存在: " + s_scheduler.getId());
        }
        if(scheduler.isStarted() && !scheduler.isPause()){
            return ResponseValue.error("调度器已运行，无需重复启动");
        }
        if(scheduler.isPause()){
            this.platformSchedulerManager.restartScheduler(s_scheduler.getId());
            logger.info("调度任务被暂停后重启，id = " + s_scheduler.getId());
        } else {
            logger.warn("调度任务已经在运行中，无需重复启动，id = " + s_scheduler.getId());
        }
        return ResponseValue.success();
    }

    @GetMapping("/list")
    public ResponseValue list(SchedulerParam schedulerParam){
        if(schedulerParam == null || schedulerParam.getOrgId() <= 0){
            return ResponseValue.error("无法查询调度任务");
        }
//        this.preparePageSearch();

        long orgId = 0;
        if(!this.isSupervisor()){
            // 普通用户，只能看到自己顶级机构用户
            orgId = this.getCurrentUser().getOrg_id();
        } else {
            orgId = schedulerParam.getOrgId();
        }

        GenericPager<S_scheduler> pager = this.schedulerService.queryPageSchedulerList(orgId);
        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
    }
}
