/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.config.CacheProperties;
import com.iplatform.base.util.cache.CacheInfo;
import com.walker.cache.CacheProvider;
import com.walker.cache.SimpleCacheManager;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/cache"})
@ConditionalOnProperty(prefix="iplatform.cache", name={"redis-enabled"}, havingValue="true", matchIfMissing=false)
public class CacheController
extends SystemController {
    private RedisTemplate<String, Object> redisTemplate;
    private CacheProperties cacheProperties;

    @Autowired(required=false)
    public CacheController(RedisTemplate<String, Object> redisTemplate, CacheProperties cacheProperties) {
        this.redisTemplate = redisTemplate;
        this.cacheProperties = cacheProperties;
    }

    @RequestMapping(value={"/clearCacheName"})
    public ResponseValue clearCacheName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return ResponseValue.error((String)"\u5fc5\u987b\u6307\u5b9a\u7f13\u5b58\u540d\u79f0");
        }
        CacheProvider cacheProvider = SimpleCacheManager.getCacheProvider((String)name);
        if (cacheProvider == null) {
            return ResponseValue.error((String)"\u7f13\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        try {
            cacheProvider.reload();
            return ResponseValue.success((String)"\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return ResponseValue.error((String)("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\u5931\u8d25:" + name));
        }
    }

    @RequestMapping(value={"/clearCacheAll"})
    public ResponseValue reloadAllCacheProvider() {
        if (!this.cacheProperties.isRedisRebuild()) {
            return ResponseValue.error((String)"\u672a\u5f00\u542f'\u91cd\u6784\u7f13\u5b58'\u9009\u9879");
        }
        Collection cacheList = SimpleCacheManager.getCacheProviders();
        if (cacheList != null && cacheList.size() > 0) {
            String name = null;
            try {
                for (CacheProvider cacheProvider : cacheList) {
                    name = cacheProvider.getProviderName();
                    cacheProvider.reload();
                }
            }
            catch (Exception ex) {
                this.logger.error("\u91cd\u65b0\u52a0\u8f7d\u6240\u6709\u7f13\u5b58\uff0c\u51fa\u73b0\u5f02\u5e38:" + ex.getMessage() + ", name=" + name, (Throwable)ex);
                return ResponseValue.error((String)("\u91cd\u65b0\u52a0\u8f7d\u7f13\u5b58\uff0c\u51fa\u73b0\u9519\u8bef\uff0cname = " + name));
            }
        }
        return ResponseValue.success();
    }

    @RequestMapping(value={"/getInfo"})
    public ResponseValue getInfo() {
        if (this.redisTemplate == null) {
            return ResponseValue.error((String)"\u7cfb\u7edf\u672a\u5f00\u542fRedis\u65b9\u5f0f\u7f13\u5b58");
        }
        Properties info = (Properties)this.redisTemplate.execute(connection -> connection.info());
        Object dbSize = this.redisTemplate.execute(connection -> connection.dbSize());
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("info", info);
        result.put("dbSize", dbSize);
        result.put("commandStats", new ArrayList());
        return ResponseValue.success(result);
    }

    @GetMapping(value={"/select/getNames"})
    public ResponseValue getCacheNames() {
        ArrayList<CacheInfo> cacheNames = new ArrayList<CacheInfo>();
        Collection cacheList = SimpleCacheManager.getCacheProviders();
        if (cacheList != null && cacheList.size() > 0) {
            for (CacheProvider cacheProvider : cacheList) {
                cacheNames.add(new CacheInfo(cacheProvider.getProviderName(), cacheProvider.getProviderType().getName()));
            }
        }
        return ResponseValue.success(cacheNames);
    }

    @GetMapping(value={"/select/getKeys/{cacheName}"})
    public ResponseValue getCacheKeys(@PathVariable String cacheName) {
        if (StringUtils.isEmpty((String)cacheName)) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ArrayList keyList = new ArrayList(256);
        CacheProvider cacheProvider = SimpleCacheManager.getCacheProvider((String)cacheName);
        if (cacheProvider != null) {
            if (cacheProvider.getCache().getPersistentSize() <= 256L) {
                return ResponseValue.success((Object)cacheProvider.getCache().getKeys());
            }
            return ResponseValue.error((String)"\u7f13\u5b58\u6570\u636e\u91cf\u8d85\u8fc7 256, \u6682\u65e0\u6cd5\u663e\u793a");
        }
        return ResponseValue.success(keyList);
    }

    @GetMapping(value={"/select/getValue/{cacheName}/{cacheKey}"})
    public ResponseValue getOneCacheValue(@PathVariable String cacheName, @PathVariable String cacheKey) {
        CacheProvider cacheProvider = SimpleCacheManager.getCacheProvider((String)cacheName);
        if (cacheProvider != null) {
            Object value = cacheProvider.getCacheData(cacheKey);
            CacheInfo cacheInfo = new CacheInfo(cacheName, cacheKey, value.toString());
            return ResponseValue.success((Object)cacheInfo);
        }
        return ResponseValue.success();
    }
}

