/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.CategoryCacheProvider;
import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.service.CategoryServiceImpl;
import com.iplatform.model.po.S_category;
import com.iplatform.model.po.S_config_form;
import com.iplatform.model.vo.CategoryTreeVo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.WebRuntimeException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/category"})
public class CategoryController
extends PlatformAdapterController {
    private CategoryServiceImpl categoryService;
    private CategoryCacheProvider categoryCacheProvider;
    private FormCacheProvider formCacheProvider;

    @Autowired
    public CategoryController(CategoryServiceImpl categoryService, CategoryCacheProvider categoryCacheProvider, FormCacheProvider formCacheProvider) {
        this.categoryService = categoryService;
        this.categoryCacheProvider = categoryCacheProvider;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value={"/list/tree"})
    public ResponseValue getListTree(@RequestParam(name="type") Integer type, @RequestParam(name="status") Integer status, @RequestParam(name="name", required=false) String name) {
        int owner = (int)this.getOwner();
        List data = this.categoryCacheProvider.getListTree(type, status, name, owner);
        if (!StringUtils.isEmptyList((List)data)) {
            data.stream().forEach(e -> {
                if (e.getType() == 6 && StringUtils.isNotEmpty((String)e.getExtra())) {
                    e.setFormName(((S_config_form)this.formCacheProvider.getCacheData(e.getExtra())).getName());
                    if (!StringUtils.isEmptyList((List)e.getChild())) {
                        for (CategoryTreeVo child : e.getChild()) {
                            if (!StringUtils.isNotEmpty((String)child.getExtra())) continue;
                            child.setFormName(((S_config_form)this.formCacheProvider.getCacheData(child.getExtra())).getName());
                        }
                    }
                }
            });
        }
        return ResponseValue.success((Object)data);
    }

    @RequestMapping(value={"/info/{id}"}, method={RequestMethod.GET})
    public ResponseValue getInfo(@PathVariable(value="id") Integer id) {
        S_category category = this.categoryCacheProvider.get(id.intValue());
        if (category == null) {
            throw new WebRuntimeException("\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        return ResponseValue.success((Object)category);
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue save(@RequestBody S_category category) {
        if (category == null) {
            return ResponseValue.error((String)"\u63d0\u4ea4\u5185\u5bb9\u9519\u8bef");
        }
        this.logger.debug(category.toString());
        if (this.categoryService.queryNameUnique(category.getName(), category.getType(), Integer.valueOf((int)this.getOwner()), 0) > 0) {
            return ResponseValue.error((String)"\u76f8\u540c\u5206\u7c7b\u5df2\u7ecf\u5b58\u5728");
        }
        long dateTime = DateUtils.getDateTimeNumber();
        int id = this.categoryService.queryNextId();
        category.setId(Integer.valueOf(id));
        category.setPath(this.getPathByPId(category.getPid()));
        category.setOwner(Integer.valueOf((int)this.getOwner()));
        category.setExtra(this.clearCdnPrefix(category.getExtra()));
        category.setCreate_time(Long.valueOf(dateTime));
        category.setUpdate_time(Long.valueOf(dateTime));
        this.categoryService.insert((BasePo)category);
        this.categoryCacheProvider.save(category);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue update(@RequestBody S_category category) {
        if (category == null || category.getId() <= 0) {
            throw new WebRuntimeException("\u5206\u7c7b\u53c2\u6570\u9519\u8bef");
        }
        S_category exist = this.categoryCacheProvider.get(category.getId().intValue());
        if (exist == null) {
            throw new WebRuntimeException("\u5206\u7c7b\u6570\u636e\u4e0d\u5b58\u5728\uff0cid=" + category.getId());
        }
        if (exist.getId().intValue() == category.getPid().intValue()) {
            throw new WebRuntimeException("\u5206\u7c7b\u7236\u7ea7\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        if (!exist.getName().equals(category.getName()) && this.categoryService.queryNameUnique(category.getName(), category.getType(), Integer.valueOf((int)this.getOwner()), exist.getId().intValue()) > 0) {
            return ResponseValue.error((String)"\u5206\u7c7b\u540d\u79f0\u91cd\u590d");
        }
        if (StringUtils.isNotEmpty((String)category.getExtra())) {
            category.setExtra(this.clearCdnPrefix(category.getExtra()));
        }
        category.setPath(this.getPathByPId(category.getPid()));
        category.setOwner(Integer.valueOf((int)this.getOwner()));
        category.setUpdate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        this.categoryService.execUpdateCategory(category);
        this.categoryCacheProvider.update(category);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete"})
    public ResponseValue delete(Integer id) {
        if (this.categoryService.queryChildCategorySize(id.intValue()) > 0) {
            return ResponseValue.error((String)"\u5f53\u524d\u5206\u7c7b\u4e0b\u6709\u5b50\u7c7b\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u7c7b\uff01");
        }
        this.categoryService.delete((BasePo)new S_category(id));
        this.categoryCacheProvider.remove(id.intValue());
        return ResponseValue.success();
    }

    private String getPathByPId(Integer pid) {
        S_category category = this.categoryCacheProvider.get(pid.intValue());
        if (category != null) {
            return category.getPath() + pid + "/";
        }
        return "/0/";
    }
}

