/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.pojo.KeywordsParam;
import com.iplatform.base.pojo.form.RequestForm;
import com.iplatform.base.service.ConfigFormServiceImpl;
import com.iplatform.model.po.S_config_form;
import com.iplatform.model.vo.ConfigFormVo;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/form"})
public class ConfigFormController
extends PlatformAdapterController {
    private ConfigFormServiceImpl configFormService;
    private FormCacheProvider formCacheProvider;

    @Autowired
    public ConfigFormController(ConfigFormServiceImpl configFormService, FormCacheProvider formCacheProvider) {
        this.configFormService = configFormService;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue edit(@RequestParam Integer id, @RequestBody RequestForm requestForm) {
        if (requestForm == null || StringUtils.isEmpty((String)requestForm.getContent()) || id == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            JsonUtils.jsonStringToObject((String)requestForm.getContent(), ConfigFormVo.class);
            S_config_form form = this.acquireConfigForm(requestForm, id);
            this.configFormService.save((BasePo)form);
            this.formCacheProvider.updateCacheData(String.valueOf(form.getId()), (Object)form);
            this.logger.info("\u7f16\u8f91\u8868\u5355\u6a21\u677f\u6210\u529f\uff1a" + requestForm.getName());
        }
        catch (Exception e) {
            this.logger.error(requestForm.getContent());
            throw new PlatformRuntimeException("\u66f4\u65b0\u8868\u5355\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e:" + e.getMessage(), (Throwable)e);
        }
        return ResponseValue.success();
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue add(@RequestBody RequestForm requestForm) {
        if (requestForm == null || StringUtils.isEmpty((String)requestForm.getContent())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            JsonUtils.jsonStringToObject((String)requestForm.getContent(), ConfigFormVo.class);
            S_config_form form = this.acquireConfigForm(requestForm, this.configFormService.queryNextId());
            this.configFormService.insert((BasePo)form);
            this.formCacheProvider.putCacheData(String.valueOf(form.getId()), (Object)form);
            this.logger.info("\u521b\u5efa\u8868\u5355\u6a21\u677f\u6210\u529f\uff1a" + requestForm.getName());
        }
        catch (Exception e) {
            this.logger.error(requestForm.getContent());
            throw new PlatformRuntimeException("\u521b\u5efa\u7684\u8868\u5355\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e:" + e.getMessage(), (Throwable)e);
        }
        return ResponseValue.success();
    }

    private S_config_form acquireConfigForm(RequestForm requestForm, int id) {
        S_config_form form = new S_config_form();
        form.setName(requestForm.getName());
        form.setInfo(requestForm.getInfo());
        form.setContent(requestForm.getContent());
        form.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        form.setUpdate_time(form.getCreate_time());
        form.setId(Integer.valueOf(id));
        return form;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(@RequestParam(value="id") Integer id) {
        if (id == null || id <= 0) {
            return ResponseValue.error();
        }
        S_config_form form = (S_config_form)this.formCacheProvider.getCacheData(id.toString());
        if (form == null) {
            return ResponseValue.error((String)("\u8868\u5355\u4e0d\u5b58\u5728, id=" + id));
        }
        return ResponseValue.success((Object)form);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(KeywordsParam keywordsParam) {
        String keywords = null;
        if (keywordsParam != null && StringUtils.isNotEmpty((String)keywordsParam.getKeywords())) {
            keywords = UrlUtils.decode((String)keywordsParam.getKeywords());
        }
        GenericPager pager = this.configFormService.queryPageFormList(keywords);
        return ResponseValue.success((Object)pager);
    }
}

