/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.DeptParam;
import com.iplatform.base.service.DeptServiceImpl;
import com.iplatform.base.util.DeptUtils;
import com.iplatform.model.po.S_dept;
import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.OrgType;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dept"})
public class DeptController
extends SystemController {
    private DeptServiceImpl deptService;

    @Autowired
    public DeptController(DeptServiceImpl deptService) {
        this.deptService = deptService;
    }

    @GetMapping(value={"/select/list_root_org"})
    public ResponseValue listOrgRoot() {
        List rootList = this.getOrgListScope();
        return ResponseValue.success((Object)rootList);
    }

    @GetMapping(value={"/select/tree_dept/{deptId}"})
    public ResponseValue listSelectDeptTree(@PathVariable Long deptId) {
        long orgId = 0L;
        if (this.isSupervisor()) {
            if (deptId == null || deptId <= 0L) {
                return ResponseValue.error((String)"\u67e5\u8be2\u4e00\u4e2a\u673a\u6784\u6811\uff0c\u5fc5\u987b\u4f20\u5165\u673a\u6784ID");
            }
            orgId = this.getRootOrgIdByDept(deptId);
        } else {
            orgId = this.getCurrentUser().getOrg_id();
        }
        List orgList = this.deptService.queryOrgListForTree(orgId);
        ArrayList treeNodeList = DeptUtils.getOrgDeptTree((List)orgList);
        if (StringUtils.isEmptyList((List)treeNodeList)) {
            treeNodeList = new ArrayList(1);
        }
        return ResponseValue.success((Object)treeNodeList);
    }

    @GetMapping(value={"/select/tree_org"})
    public ResponseValue listOrgRootTree() {
        List orgList = null;
        if (this.isSupervisor()) {
            orgList = this.deptService.queryOrgListForTree(-1L);
        } else {
            long orgId = this.getCurrentUser().getOrg_id();
            orgList = this.deptService.queryOrgListForTree(orgId);
        }
        List treeNodeList = DeptUtils.getOrgDeptTree((List)orgList);
        if (StringUtils.isEmptyList((List)treeNodeList)) {
            this.logger.error("\u672a\u627e\u5230\u4efb\u4f55\u9876\u7ea7\u673a\u6784\u6811\u5217\u8868: treeNodeList = null");
        } else {
            this.logger.debug(treeNodeList.toString());
        }
        return ResponseValue.success((Object)treeNodeList);
    }

    @GetMapping(value={"/list"})
    public ResponseValue listOrgList(DeptParam deptParam) {
        String deptDataScope = this.getCurrentDataScope("103");
        this.logger.info("\u90e8\u95e8\u7ba1\u7406(\u6570\u636e\u6743\u9650) = " + deptDataScope);
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        if (deptParam.getLoadSelect() == 1) {
            List selectParentList = this.deptService.queryRootOrgChildrenList(deptParam.getOrgId(), null);
            data.put("deptList", DeptUtils.toSystemDeptList((List)selectParentList));
            return ResponseValue.success(data);
        }
        List rootList = this.getOrgListScope();
        S_user_core currentUser = this.getCurrentUser();
        List deptSrcList = null;
        long selectedOrgRoot = 0L;
        if (currentUser.getUser_type() == 0) {
            if (deptParam != null && deptParam.getOrgId() > 0L) {
                selectedOrgRoot = deptParam.getOrgId();
            } else if (!StringUtils.isEmptyList((List)rootList)) {
                selectedOrgRoot = ((S_dept)rootList.get(0)).getId();
            }
            deptSrcList = this.deptService.queryRootOrgChildrenList(selectedOrgRoot, deptParam.getDeptName());
            data.put("deptList", DeptUtils.toSystemDeptList((List)deptSrcList));
        } else {
            deptSrcList = this.deptService.queryRootOrgChildrenList(currentUser.getOrg_id().longValue(), deptParam.getDeptName());
            data.put("deptList", DeptUtils.toSystemDeptList((List)deptSrcList));
        }
        if (deptParam.getOrgId() > 0L) {
            data.put("selectedRootOrgId", deptParam.getOrgId());
        } else {
            data.put("selectedRootOrgId", ((S_dept)rootList.get(0)).getId());
        }
        data.put("rootOrgList", rootList);
        return ResponseValue.success(data);
    }

    @PostMapping(value={"/add"})
    public ResponseValue saveAddDept(@RequestBody S_dept s_dept) {
        if (s_dept == null || StringUtils.isEmpty((String)s_dept.getDept_name())) {
            return ResponseValue.error((String)"\u63d0\u4ea4\u4fdd\u5b58\u673a\u6784\u4e3a\u7a7a");
        }
        this.logger.info(s_dept.toString());
        s_dept.setId(Long.valueOf(NumberGenerator.getSequenceNumber()));
        s_dept.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        s_dept.setCreate_by(this.getCurrentUser().getUser_name());
        Long parentId = s_dept.getParent_id();
        if (parentId == null || parentId == 0L) {
            s_dept.setOrg_id(s_dept.getId());
            s_dept.setParent_id(Long.valueOf(0L));
            s_dept.setAncestors("0");
            if (s_dept.getOrg_type() != 0) {
                return ResponseValue.error((String)"\u9876\u7ea7\u673a\u6784\u53ea\u80fd\u9009\u62e9\u7b2c\u4e00\u9879");
            }
        } else {
            S_dept parentDept = this.deptService.queryOneDept(parentId.longValue());
            if (parentDept == null) {
                return ResponseValue.error((String)"\u4e0a\u7ea7\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            if (parentDept.getStatus() != 0) {
                return ResponseValue.error((String)"\u8be5\u673a\u6784\u5df2\u505c\u7528\uff0c\u65e0\u6cd5\u521b\u5efa\u5b50\u673a\u6784");
            }
            s_dept.setOrg_id(parentDept.getOrg_id());
            s_dept.setAncestors(parentDept.getAncestors() + "," + s_dept.getParent_id());
            String error = this.checkOrgType(parentDept.getOrg_type(), s_dept.getOrg_type());
            if (error != null) {
                return ResponseValue.error((String)error);
            }
        }
        this.deptService.insert((BasePo)s_dept);
        this.getDeptCacheProvider().putDept(s_dept);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/remove/{deptId}"})
    public ResponseValue removeDept(@PathVariable Long deptId) {
        if (deptId == null || deptId <= 0L) {
            return ResponseValue.error((String)"\u673a\u6784\u53c2\u6570\u9519\u8bef");
        }
        int subDeptSize = this.deptService.querySubDeptSizeInCurrent(deptId.longValue());
        if (subDeptSize > 0) {
            return ResponseValue.error((String)"\u8be5\u673a\u6784\u4e0b\u5b58\u5728\u5b50\u673a\u6784\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        long userSize = this.deptService.queryUserSizeInCurrent(deptId.longValue());
        if (userSize > 0L) {
            return ResponseValue.error((String)"\u8be5\u673a\u6784\u4e0b\u5b58\u5728\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.deptService.delete((BasePo)new S_dept(deptId));
        this.getDeptCacheProvider().removeDept(deptId.longValue());
        return ResponseValue.success();
    }

    @PostMapping(value={"/edit"})
    public ResponseValue saveEdit(@RequestBody S_dept s_dept) {
        if (s_dept == null) {
            return ResponseValue.error((String)"\u7f16\u8f91\u7684\u673a\u6784\u4e0d\u5b58\u5728");
        }
        Long deptId = s_dept.getId();
        if (deptId == null || deptId <= 0L) {
            return ResponseValue.error((String)"\u7f16\u8f91\u7684\u673a\u6784ID\u4e0d\u5b58\u5728");
        }
        Long parentId = s_dept.getParent_id();
        if (parentId == null || parentId == 0L) {
            if (s_dept.getOrg_type() != 0) {
                return ResponseValue.error((String)"\u9876\u7ea7\u673a\u6784\u53ea\u80fd\u9009\u62e9\u4e00\u7ea7\u673a\u6784");
            }
        } else {
            S_dept parentDept = this.deptService.queryOneDept(parentId.longValue());
            if (parentDept == null) {
                return ResponseValue.error((String)"\u4e0a\u7ea7\u5355\u4f4d\u4e0d\u5b58\u5728");
            }
            String error = this.checkOrgType(parentDept.getOrg_type(), s_dept.getOrg_type());
            if (error != null) {
                return ResponseValue.error((String)error);
            }
        }
        s_dept.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        this.deptService.save((BasePo)s_dept);
        this.getDeptCacheProvider().updateDept(s_dept);
        return ResponseValue.success();
    }

    @GetMapping(value={"/view/{deptId}"})
    public ResponseValue viewDept(@PathVariable Long deptId) {
        if (deptId == null || deptId <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        S_dept s_dept = this.deptService.queryOneDept(deptId.longValue());
        if (s_dept == null) {
            return ResponseValue.error((String)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        return ResponseValue.success((Object)s_dept);
    }

    private String checkOrgType(int parentOrgTypeValue, int currentOrgTypeValue) {
        OrgType parentOrgType = OrgType.getType((int)parentOrgTypeValue);
        OrgType currentOrtType = OrgType.getType((int)currentOrgTypeValue);
        if (currentOrtType == OrgType.OrgSub) {
            if (parentOrgType != OrgType.Org) {
                return "\u4e8c\u7ea7\u5355\u4f4d\u53ea\u80fd\u5728\u9876\u7ea7\u5355\u4f4d\u4e0b\u9762";
            }
        } else if (currentOrtType == OrgType.OrgFactory) {
            if (parentOrgType != OrgType.OrgSub) {
                return "\u4e09\u7ea7\u5355\u4f4d\u53ea\u80fd\u5728\u4e8c\u7ea7\u5355\u4f4d\u4e0b\u9762";
            }
        } else if (currentOrtType == OrgType.OrgSubFactory && parentOrgType != OrgType.OrgFactory) {
            return "\u56db\u7ea7\u5355\u4f4d\u53ea\u80fd\u5728\u4e09\u7ea7\u7ea7\u5355\u4f4d\u4e0b\u9762";
        }
        return null;
    }
}

