/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.PlatformAdapterController;
import com.iplatform.base.PlatformRuntimeException;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.pojo.GroupDataParam;
import com.iplatform.base.pojo.KeywordsParam;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.group.GroupData;
import com.iplatform.base.service.GroupServiceImpl;
import com.iplatform.model.po.S_group;
import com.iplatform.model.po.S_group_data;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.infrastructure.utils.UrlUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/group"})
public class GroupController
extends PlatformAdapterController {
    private GroupServiceImpl groupService;
    private FormCacheProvider formCacheProvider;

    @Autowired
    public GroupController(GroupServiceImpl groupService, FormCacheProvider formCacheProvider) {
        this.groupService = groupService;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseValue updateGroup(@RequestBody S_group group) {
        if (group == null || StringUtils.isEmpty((String)group.getName()) || group.getId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        group.setUpdate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        this.groupService.save((BasePo)group);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResponseValue deleteGroup(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u53c2\u6570");
        }
        S_group_data groupData = new S_group_data();
        groupData.setGid(id);
        List groupDataList = this.groupService.select((BasePo)groupData);
        if (!StringUtils.isEmptyList((List)groupDataList)) {
            return ResponseValue.error((String)"\u5206\u7ec4\u4e0b\u5b58\u5728\u6570\u636e\u9879\uff0c\u65e0\u6cd5\u5220\u9664!");
        }
        this.groupService.delete((BasePo)new S_group(id));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseValue saveGroup(@RequestBody S_group group) {
        if (group == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        group.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        group.setUpdate_time(group.getCreate_time());
        group.setId(Integer.valueOf(this.groupService.queryGroupNextId()));
        this.groupService.insert((BasePo)group);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/data/delete"}, method={RequestMethod.GET})
    public ResponseValue deleteData(@RequestParam(value="id") Integer id) {
        this.groupService.delete((BasePo)new S_group_data(id));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/data/update"}, method={RequestMethod.POST})
    public ResponseValue updateData(@RequestParam Integer id, @RequestBody GroupData groupData) {
        if (groupData == null || id == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        String value = this.acquireFormValue(groupData.getForm());
        S_group_data group_data = new S_group_data();
        group_data.setGid(groupData.getGid());
        group_data.setValue(this.clearCdnPrefix(value));
        group_data.setSort(groupData.getForm().getSort());
        group_data.setStatus(groupData.getForm().getStatus());
        group_data.setUpdate_time(group_data.getCreate_time());
        group_data.setId(id);
        this.groupService.save((BasePo)group_data);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/data/save"}, method={RequestMethod.POST})
    public ResponseValue saveData(@RequestBody GroupData groupData) {
        if (groupData == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        String value = this.acquireFormValue(groupData.getForm());
        int nextId = this.groupService.queryGroupDataNextId();
        S_group_data group_data = new S_group_data();
        group_data.setGid(groupData.getGid());
        group_data.setValue(this.clearCdnPrefix(value));
        group_data.setSort(groupData.getForm().getSort());
        group_data.setStatus(groupData.getForm().getStatus());
        group_data.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber()));
        group_data.setUpdate_time(group_data.getCreate_time());
        group_data.setId(Integer.valueOf(nextId));
        this.groupService.insert((BasePo)group_data);
        return ResponseValue.success();
    }

    private String acquireFormValue(FormData formData) {
        this.formCacheProvider.validateForm(formData);
        try {
            return JsonUtils.objectToJsonString((Object)formData);
        }
        catch (Exception e) {
            throw new PlatformRuntimeException("\u8f6c\u6362Json\u5b57\u7b26\u4e32\u5931\u8d25\uff1a" + formData.getId(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/data/list"}, method={RequestMethod.GET})
    public ResponseValue listData(GroupDataParam groupDataParam) {
        if (groupDataParam == null || groupDataParam.getGid() == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef:groupDataParam");
        }
        GenericPager pager = this.groupService.queryPageGroupDataList(groupDataParam.getGid().intValue(), groupDataParam.getStatus());
        pager.getDatas().stream().forEach(data -> {
            try {
                FormData formData = (FormData)JsonUtils.jsonStringToObject((String)data.getValue(), FormData.class);
                data.setValue(JsonUtils.objectToJsonString((Object)formData));
                this.logger.info(data.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(KeywordsParam keywordsParam) {
        String keywords = null;
        if (keywordsParam != null && StringUtils.isNotEmpty((String)keywordsParam.getKeywords())) {
            keywords = UrlUtils.decode((String)keywordsParam.getKeywords());
        }
        GenericPager pager = this.groupService.queryPageGroupList(keywords);
        return ResponseValue.success((Object)pager);
    }
}

