/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.service.CodeServiceImpl;
import com.iplatform.base.support.DictTreeGenerator;
import com.iplatform.model.po.S_dict_data;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permit"})
public class PermitController
extends SystemController {
    private CodeServiceImpl codeService;

    @RequestMapping(value={"/config/front/domain"})
    public ResponseValue getConfigFrontDomain() {
        String data = this.getArgumentVariable("site_url").getStringValue();
        return ResponseValue.success((String)"success", (Object)data);
    }

    @RequestMapping(value={"/file/{id}"})
    public void downloadLocalFile(@PathVariable String id) throws Exception {
        FileInfo fileInfo = this.getFileInfo(id);
        if (fileInfo == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u672a\u627e\u5230\uff0cid=" + id);
        }
        this.logger.info("\u5f00\u59cb\u4e0b\u8f7d\u672c\u5730\u6587\u4ef6:{}", (Object)fileInfo);
        this.downloadSimpleFile(this.getLocalFileData(fileInfo), fileInfo.getFileName());
    }

    @RequestMapping(value={"/dict/data/type/{dictType}"})
    public ResponseValue<List<S_dict_data>> dictTypeList(@PathVariable String dictType) {
        this.logger.debug("dictType = " + dictType);
        String id = this.getDictCacheProvider().getDictTypeId(dictType);
        ArrayList list = this.getDictCacheProvider().getRootChildrenOneLevelList(id);
        if (StringUtils.isEmptyList((List)list)) {
            list = new ArrayList(2);
        }
        return ResponseValue.success((Object)list);
    }

    @RequestMapping(value={"/dict/list_tree/{dictType}"})
    public ResponseValue selectDictTreeList(@PathVariable String dictType) {
        if (StringUtils.isEmpty((String)dictType)) {
            return ResponseValue.error((String)"\u8bf7\u63d0\u4f9b\u5b57\u5178\u7c7b\u578b!");
        }
        ArrayList treeNodeList = new ArrayList(8);
        List dictDataList = this.codeService.queryDictTreeList(dictType);
        if (StringUtils.isEmptyList((List)dictDataList)) {
            return ResponseValue.success(treeNodeList);
        }
        long defaultParentId = ((S_dict_data)dictDataList.get(0)).getParent_id();
        DictTreeGenerator generator = new DictTreeGenerator(null);
        generator.setDefaultParentId(defaultParentId);
        generator.setEntityList(dictDataList);
        return ResponseValue.success((Object)generator.getTreeRootList());
    }

    @Autowired
    public PermitController(CodeServiceImpl codeService) {
        this.codeService = codeService;
    }
}

