/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.event.RoleSecurityChangeEvent;
import com.iplatform.base.pojo.role.RoleAuthParam;
import com.iplatform.base.pojo.role.RoleParam;
import com.iplatform.base.pojo.role.RoleUserParam;
import com.iplatform.base.service.RoleServiceImpl;
import com.iplatform.base.util.role.SystemRole;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_role;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/role"})
public class RoleController
extends SystemController {
    private RoleServiceImpl roleService;

    @Autowired
    public RoleController(RoleServiceImpl roleService) {
        this.roleService = roleService;
    }

    @RequestMapping(value={"/select/authUser/all"})
    public ResponseValue batchAuthUserList(Long roleId, Long[] userIds) {
        if (userIds == null || userIds.length == 0 || roleId == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.debug(roleId + ", " + userIds);
        this.roleService.execInsertRoleUserList(roleId.longValue(), userIds);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/select/authUser/cancel"})
    public ResponseValue cancelAuthUser(@RequestBody RoleUserParam roleUserParam) {
        if (roleUserParam == null || roleUserParam.getRoleId() == null || roleUserParam.getUserId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.roleService.execDeleteRoleUser(roleUserParam.getRoleId().longValue(), roleUserParam.getUserId().longValue());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/select/authUser/unallocatedList"})
    public ResponseValue unallocatedList(RoleAuthParam roleAuthParam) {
        if (roleAuthParam == null || roleAuthParam.getRoleId() == null) {
            return ResponseValue.error();
        }
        this.preparePageSearch();
        S_role s_role = (S_role)this.roleService.get((BasePo)new S_role(roleAuthParam.getRoleId()));
        GenericPager pager = this.roleService.queryUnAllocatedUserList(roleAuthParam.getRoleId().longValue(), s_role.getOrg_id().longValue(), roleAuthParam.getUserName());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/select/authUser/allocatedList"})
    public ResponseValue allocatedList(RoleAuthParam roleAuthParam) {
        if (roleAuthParam == null || roleAuthParam.getRoleId() == null) {
            return ResponseValue.error();
        }
        this.preparePageSearch();
        GenericPager pager = this.roleService.queryAllocatedUserList(roleAuthParam.getRoleId().longValue(), roleAuthParam.getUserName());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/edit"})
    public ResponseValue saveEdit(@RequestBody SystemRole systemRole) {
        if (systemRole == null || StringUtils.isEmpty((String)systemRole.getRole_name()) || systemRole.getOrg_id() == null || systemRole.getRole_id() == null) {
            return ResponseValue.error((String)"\u89d2\u8272\u53c2\u6570\u9519\u8bef");
        }
        long orgId = systemRole.getOrg_id();
        S_role existRole = this.roleService.queryRoleByName(orgId, systemRole.getRole_name());
        if (existRole != null && existRole.getRole_id().longValue() != systemRole.getRole_id().longValue()) {
            return ResponseValue.error((String)"\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        this.roleService.execUpdateRole(systemRole.$clone(), systemRole.getMenuIds());
        BeanContextAware.publishEvent((ApplicationEvent)new RoleSecurityChangeEvent((Object)systemRole.getRole_id()));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/view/{roleId}"})
    public ResponseValue view(@PathVariable Long roleId) {
        S_role s_role = (S_role)this.roleService.get((BasePo)new S_role(roleId));
        if (s_role == null) {
            return ResponseValue.error((String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        return ResponseValue.success((Object)s_role);
    }

    @RequestMapping(value={"/remove/{roleId}"})
    public ResponseValue removeRole(@PathVariable Long roleId) {
        if (roleId == null || roleId <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        int roleUserCount = this.roleService.queryRoleUserSize(roleId.longValue());
        if (roleUserCount > 0) {
            return ResponseValue.error((String)"\u89d2\u8272\u5df2\u5206\u914d\u7528\u6237\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.roleService.execDeleteRole(roleId.longValue());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/add"})
    public ResponseValue saveAdd(@RequestBody SystemRole systemRole) {
        if (systemRole == null || StringUtils.isEmpty((String)systemRole.getRole_name()) || systemRole.getOrg_id() == null) {
            return ResponseValue.error((String)"\u89d2\u8272\u53c2\u6570\u9519\u8bef");
        }
        long orgId = systemRole.getOrg_id();
        if (orgId <= 0L) {
            return ResponseValue.error((String)"\u89d2\u8272\u6240\u5c5e\u673a\u6784\u5fc5\u987b\u63d0\u4f9b");
        }
        S_role existRole = this.roleService.queryRoleByName(orgId, systemRole.getRole_name());
        if (existRole != null) {
            return ResponseValue.error((String)"\u89d2\u8272\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        systemRole.setRole_id(Long.valueOf(NumberGenerator.getSequenceNumber()));
        this.roleService.execInsertRole(systemRole.$clone(), systemRole.getMenuIds());
        return ResponseValue.success();
    }

    @PostMapping(value={"/select/changeStatus"})
    public ResponseValue changeStatus(@RequestBody S_role s_role) {
        if (s_role == null || s_role.getRole_id() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.roleService.execUpdateStatus(s_role.getRole_id().longValue(), s_role.getStatus().intValue());
        return ResponseValue.success();
    }

    @GetMapping(value={"/list"})
    public ResponseValue pageList(RoleParam roleParam) {
        if (roleParam == null || roleParam.getOrgId() <= 0L) {
            return ResponseValue.error((String)"\u65e0\u6cd5\u67e5\u8be2\u89d2\u8272:\u6ca1\u6709\u6761\u4ef6");
        }
        long orgId = 0L;
        orgId = !this.isSupervisor() ? this.getCurrentUser().getOrg_id().longValue() : roleParam.getOrgId();
        GenericPager pager = this.roleService.queryPageRoleList(orgId, roleParam.getStatus(), roleParam.getRoleName());
        return ResponseValue.success((Object)pager);
    }
}

