/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.model.po.S_scheduler;
import com.iplatform.scheduler.PlatformSchedulerManager;
import com.iplatform.scheduler.pojo.SchedulerParam;
import com.iplatform.scheduler.service.SchedulerServiceImpl;
import com.walker.db.page.GenericPager;
import com.walker.scheduler.AbstractScheduler;
import com.walker.web.ResponseValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/job"})
@ConditionalOnProperty(prefix="iplatform.scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SchedulerController
extends SystemController {
    private SchedulerServiceImpl schedulerService;
    private PlatformSchedulerManager platformSchedulerManager;

    @Autowired
    public SchedulerController(SchedulerServiceImpl schedulerService, PlatformSchedulerManager platformSchedulerManager) {
        this.schedulerService = schedulerService;
        this.platformSchedulerManager = platformSchedulerManager;
    }

    @RequestMapping(value={"/select/run"})
    public ResponseValue run(@RequestBody S_scheduler s_scheduler) {
        if (this.platformSchedulerManager == null) {
            return ResponseValue.error((String)"\u8c03\u5ea6\u6a21\u5757\u672a\u5f00\u542f\u914d\u7f6e");
        }
        if (s_scheduler == null) {
            return ResponseValue.error((String)"\u8c03\u5ea6\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        AbstractScheduler scheduler = this.platformSchedulerManager.getOneGatherScheduler(s_scheduler.getId().intValue());
        if (scheduler == null) {
            return ResponseValue.error((String)("\u8c03\u5ea6\u5668\u4e0d\u5b58\u5728: " + s_scheduler.getId()));
        }
        if (scheduler.isStarted() && !scheduler.isPause()) {
            return ResponseValue.error((String)"\u8c03\u5ea6\u5668\u5df2\u8fd0\u884c\uff0c\u65e0\u9700\u91cd\u590d\u542f\u52a8");
        }
        if (scheduler.isPause()) {
            this.platformSchedulerManager.restartScheduler(s_scheduler.getId().intValue());
            this.logger.info("\u8c03\u5ea6\u4efb\u52a1\u88ab\u6682\u505c\u540e\u91cd\u542f\uff0cid = " + s_scheduler.getId());
        } else {
            this.logger.warn("\u8c03\u5ea6\u4efb\u52a1\u5df2\u7ecf\u5728\u8fd0\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u542f\u52a8\uff0cid = " + s_scheduler.getId());
        }
        return ResponseValue.success();
    }

    @GetMapping(value={"/list"})
    public ResponseValue list(SchedulerParam schedulerParam) {
        if (schedulerParam == null || schedulerParam.getOrgId() <= 0L) {
            return ResponseValue.error((String)"\u65e0\u6cd5\u67e5\u8be2\u8c03\u5ea6\u4efb\u52a1");
        }
        long orgId = 0L;
        orgId = !this.isSupervisor() ? this.getCurrentUser().getOrg_id().longValue() : schedulerParam.getOrgId();
        GenericPager pager = this.schedulerService.queryPageSchedulerList(orgId);
        return this.acquireTablePage(pager.getDatas(), pager.getTotalRows());
    }
}

