/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.dict.DictParam;
import com.iplatform.base.service.CodeServiceImpl;
import com.iplatform.model.po.S_dict_data;
import com.iplatform.model.po.S_dict_type;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dict"})
public class CodeController
extends SystemController {
    private CodeServiceImpl codeService;

    @Autowired
    public CodeController(CodeServiceImpl codeService) {
        this.codeService = codeService;
    }

    @RequestMapping(value={"/type/list"})
    public ResponseValue listType(DictParam dictParam) {
        this.logger.debug(dictParam.toString());
        long beginTime = -1L;
        long endTime = -1L;
        if (dictParam.getParams().get("beginTime") != null) {
            beginTime = this.getParamsDateTime(dictParam.getParams().get("beginTime").toString(), false);
        }
        if (dictParam.getParams().get("endTime") != null) {
            endTime = this.getParamsDateTime(dictParam.getParams().get("endTime").toString(), false);
        }
        this.logger.debug("beginTime = " + beginTime + ", endTime = " + endTime);
        GenericPager pager = this.codeService.queryPageDictType(dictParam.getDictName(), dictParam.getDictType(), dictParam.getStatus(), beginTime, endTime);
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/type/{dictId}"})
    public ResponseValue detailDictType(@PathVariable Long dictId) {
        if (dictId == null || dictId <= 0L) {
            return ResponseValue.error((String)"\u5b57\u5178id\u9519\u8bef");
        }
        return ResponseValue.success((Object)this.codeService.queryOneDictType(dictId.longValue()));
    }

    @GetMapping(value={"/data/optionselect"})
    public ResponseValue showDictTypeListAll() {
        List list = this.codeService.selectAll((BasePo)new S_dict_type());
        return ResponseValue.success((Object)list);
    }

    @RequestMapping(value={"/data/type/{dictType}"})
    public ResponseValue<List<S_dict_data>> dictTypeList(@PathVariable String dictType) {
        this.logger.debug("dictType = " + dictType);
        ArrayList list = this.codeService.queryDictDataByType(dictType);
        if (StringUtils.isEmptyList((List)list)) {
            list = new ArrayList(2);
        }
        return ResponseValue.success((Object)list);
    }

    @RequestMapping(value={"/data/list"})
    public ResponseValue listData(DictParam dictParam) {
        if (StringUtils.isEmpty((String)dictParam.getDictType())) {
            return ResponseValue.error((String)"\u5fc5\u987b\u63d0\u4f9b\u5b57\u5178\u7c7b\u578b\u53c2\u6570");
        }
        GenericPager pager = this.codeService.queryPageDictData(dictParam.getDictType(), dictParam.getDictLabel());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/add"})
    public ResponseValue insertDictData(@RequestBody S_dict_data s_dict_data) {
        this.logger.debug(s_dict_data.toString());
        if (s_dict_data.getDict_code() == null) {
            return ResponseValue.error((String)"\u5b57\u5178id\u5fc5\u987b\u8f93\u5165!");
        }
        if (s_dict_data.getParent_id() == null) {
            return ResponseValue.error((String)"\u7236id\u5fc5\u987b\u8f93\u5165!");
        }
        S_dict_data dict_data = (S_dict_data)this.getDictCacheProvider().getCacheData(String.valueOf(s_dict_data.getDict_code()));
        if (dict_data != null) {
            return ResponseValue.error((String)"\u5b57\u5178id\u5df2\u5b58\u5728!");
        }
        String error = this.validateDictData(s_dict_data, true);
        if (error != null) {
            return ResponseValue.error((String)error);
        }
        if (StringUtils.isEmpty((String)s_dict_data.getDict_value())) {
            s_dict_data.setDict_value(String.valueOf(s_dict_data.getDict_code()));
        }
        s_dict_data.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        this.codeService.insert((BasePo)s_dict_data);
        this.getDictCacheProvider().putCacheData(String.valueOf(s_dict_data.getDict_code()), (Object)s_dict_data);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/data/{dictCode}"})
    public ResponseValue getDictDataInfo(@PathVariable Long dictCode) {
        S_dict_data e = this.codeService.queryOneDictData(dictCode.longValue());
        return ResponseValue.success((Object)e);
    }

    @RequestMapping(value={"/edit"})
    public ResponseValue updateDictData(@RequestBody S_dict_data s_dict_data) {
        String error = this.validateDictData(s_dict_data, false);
        if (error != null) {
            return ResponseValue.error((String)error);
        }
        this.codeService.save((BasePo)s_dict_data);
        this.getDictCacheProvider().updateCacheData(String.valueOf(s_dict_data.getDict_code()), (Object)s_dict_data);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/data/remove/{dictCodes}"})
    public ResponseValue removeDictData(@PathVariable Long[] dictCodes) {
        if (dictCodes == null) {
            return ResponseValue.error((String)"\u6ca1\u6709\u5b57\u5178\u53c2\u6570");
        }
        this.codeService.execDeleteDictData(dictCodes);
        Long[] longArray = dictCodes;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long code = longArray[i];
            this.getDictCacheProvider().removeCacheData(String.valueOf(code));
        }
        return ResponseValue.success();
    }

    private String validateDictData(S_dict_data s_dict_data, boolean checkExist) {
        S_dict_data exist;
        if (s_dict_data == null) {
            return "\u63d0\u4ea4\u5b57\u5178\u5185\u5bb9\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((String)s_dict_data.getDict_type())) {
            return "\u8bf7\u9009\u62e9\u5b57\u5178\u7c7b\u578b";
        }
        if (StringUtils.isEmpty((String)s_dict_data.getDict_label())) {
            return "\u8bf7\u8f93\u5165\u5b57\u5178\u6807\u7b7e";
        }
        if (checkExist && (exist = this.codeService.queryOneDictData(s_dict_data.getDict_type(), s_dict_data.getDict_value())) != null) {
            return "\u5df2\u7ecf\u5b58\u5728\u8be5\u5b57\u5178\u503c\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        }
        return null;
    }
}

