/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.cache.FormCacheProvider;
import com.iplatform.base.pojo.ConfigParam;
import com.iplatform.base.pojo.form.FormData;
import com.iplatform.base.pojo.form.FormDataItem;
import com.iplatform.base.service.ConfigArgumentServiceImpl;
import com.iplatform.model.po.S_config;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/config"})
public class ConfigController
extends SystemController {
    private ConfigArgumentServiceImpl configArgumentService;
    private ArgumentsManager argumentsManager = null;
    private FormCacheProvider formCacheProvider;

    @Autowired
    public ConfigController(ConfigArgumentServiceImpl configArgumentService, ArgumentsManager argumentsManager, FormCacheProvider formCacheProvider) {
        this.configArgumentService = configArgumentService;
        this.argumentsManager = argumentsManager;
        this.formCacheProvider = formCacheProvider;
    }

    @RequestMapping(value={"/list"})
    public ResponseValue list(ConfigParam configParam) {
        GenericPager pager = this.configArgumentService.queryPageConfigList(configParam.getConfigName(), configParam.getConfigKey(), configParam.getConfigType());
        return ResponseValue.success((Object)pager);
    }

    @RequestMapping(value={"/view/{configId}"})
    public ResponseValue view(@PathVariable Long configId) {
        if (configId == null || configId <= 0L) {
            return ResponseValue.error((String)"config id required!");
        }
        S_config s_config = (S_config)this.configArgumentService.get((BasePo)new S_config(configId));
        return ResponseValue.success((Object)s_config);
    }

    @RequestMapping(value={"/edit"})
    public ResponseValue saveEdit(@RequestBody S_config s_config) {
        S_config exist = (S_config)this.configArgumentService.get((BasePo)new S_config(s_config.getConfig_id()));
        if (exist == null) {
            return ResponseValue.error((String)("\u914d\u7f6e\u9879\u4e0d\u5b58\u5728: " + s_config.getConfig_id()));
        }
        this.configArgumentService.save((BasePo)s_config);
        this.argumentsManager.persist(s_config.getConfig_key(), (Object)s_config.getConfig_value());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/add"})
    public ResponseValue saveAdd(@RequestBody S_config s_config) {
        if (s_config == null || StringUtils.isEmpty((String)s_config.getConfig_key())) {
            return ResponseValue.error((String)"\u63d0\u4ea4\u914d\u7f6e\u6570\u636e\u9519\u8bef");
        }
        S_config exist = this.configArgumentService.queryConfigByKey(s_config.getConfig_key());
        if (exist != null) {
            return ResponseValue.error((String)("\u914d\u7f6e\u9879\u5df2\u7ecf\u5b58\u5728: " + s_config.getConfig_key()));
        }
        s_config.setConfig_id(Long.valueOf(NumberGenerator.getSequenceNumber()));
        s_config.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        this.configArgumentService.insert((BasePo)s_config);
        this.argumentsManager.persist(s_config.getConfig_key(), (Object)s_config.getConfig_value());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/getuniq"}, method={RequestMethod.GET})
    public ResponseValue getConfigValue(@RequestParam String key) {
        String configValue = this.getArgumentVariable(key).getStringValue();
        return ResponseValue.success((String)"success", (Object)configValue);
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ResponseValue info(@RequestParam(value="formId") Integer formId) {
        if (formId == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        List list = this.argumentsManager.getVariableList(String.valueOf(formId));
        if (StringUtils.isEmptyList((List)list)) {
            return ResponseValue.success(new HashMap(1));
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Variable systemConfig : list) {
            map.put(systemConfig.getId(), systemConfig.getStringValue());
        }
        map.put("id", formId.toString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(map.toString());
        }
        return ResponseValue.success(map);
    }

    @RequestMapping(value={"/save/form"}, method={RequestMethod.POST})
    public ResponseValue saveFormConfig(@RequestBody FormData formData) {
        if (formData == null || formData.getId() == null || StringUtils.isEmptyList((List)formData.getFields())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        try {
            this.formCacheProvider.validateForm(formData);
        }
        catch (Exception ex) {
            return ResponseValue.error((String)("\u8868\u5355\u914d\u7f6e\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a" + ex.getMessage()));
        }
        ArrayList<Object[]> savedConfigList = new ArrayList<Object[]>(8);
        Object[] config = null;
        String value = null;
        for (FormDataItem formDataItem : formData.getFields()) {
            value = this.clearCdnPrefix(formDataItem.getValue());
            if (StringUtils.isEmpty((String)value)) {
                this.logger.debug("\u914d\u7f6e\u7684\u503c\u662f\uff1a\u56fe\u7247\u57df\u540d\uff0c" + formDataItem.getValue());
                value = formDataItem.getValue();
            }
            config = new Object[]{value, formDataItem.getName()};
            savedConfigList.add(config);
        }
        this.configArgumentService.execUpdateFormConfig(savedConfigList);
        for (Object[] one : savedConfigList) {
            this.argumentsManager.persist(one[1].toString(), one[0]);
        }
        return ResponseValue.success();
    }
}

