/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.event.RoleSecurityChangeEvent;
import com.iplatform.base.service.MenuServiceImpl;
import com.iplatform.base.service.RoleServiceImpl;
import com.iplatform.base.util.menu.SystemMenu;
import com.iplatform.core.BeanContextAware;
import com.iplatform.model.po.S_menu;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.UserPrincipal;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/menu"})
public class MenuController
extends SystemController {
    private MenuCacheProvider menuCacheProvider;
    private RoleServiceImpl roleService;
    private MenuServiceImpl menuService;

    @Autowired
    public MenuController(MenuCacheProvider menuCacheProvider, RoleServiceImpl roleService, MenuServiceImpl menuService) {
        this.menuCacheProvider = menuCacheProvider;
        this.roleService = roleService;
        this.menuService = menuService;
    }

    @RequestMapping(value={"/remove/{menuId}"})
    public ResponseValue remove(@PathVariable String menuId) {
        boolean existChildren = this.menuCacheProvider.isHasChildren(menuId);
        if (existChildren) {
            return ResponseValue.error((String)"\u8be5\u83dc\u5355\u5b58\u5728\u5b50\u83dc\u5355\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        int roleMenuSize = this.menuService.queryRoleMenuSize(menuId);
        if (roleMenuSize > 0) {
            return ResponseValue.error((String)"\u83dc\u5355\u5df2\u5206\u914d\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.menuService.delete((BasePo)new S_menu(menuId));
        this.menuCacheProvider.removeCacheData(menuId);
        BeanContextAware.publishEvent((ApplicationEvent)new RoleSecurityChangeEvent((Object)("menu:" + menuId)));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/view/{menuId}"})
    public ResponseValue view(@PathVariable String menuId) {
        S_menu s_menu = (S_menu)this.menuService.get((BasePo)new S_menu(menuId));
        if (s_menu == null) {
            return ResponseValue.error((String)("\u83dc\u5355\u4e0d\u5b58\u5728:" + menuId));
        }
        return ResponseValue.success((Object)new SystemMenu(s_menu));
    }

    @RequestMapping(value={"/edit"})
    public ResponseValue saveEdit(@RequestBody S_menu s_menu) {
        if (s_menu == null || StringUtils.isEmpty((String)s_menu.getParent_id()) || StringUtils.isEmpty((String)s_menu.getMenu_name())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        S_menu exist = this.menuService.queryExistMenuInParent(s_menu.getParent_id(), s_menu.getMenu_name());
        if (exist != null && !exist.getMenu_id().equals(s_menu.getMenu_id())) {
            return ResponseValue.error((String)("\u7236\u83dc\u5355\u4e0b\u5df2\u6709\u76f8\u540c\u540d\u79f0\u83dc\u5355\u5b58\u5728:" + s_menu.getMenu_name()));
        }
        if (s_menu.getIs_frame() == 0 && !StringUtils.isHttpLink((String)s_menu.getPath())) {
            return ResponseValue.error((String)"\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934");
        }
        if (s_menu.getMenu_type().equals("C") && StringUtils.isEmpty((String)s_menu.getComponent())) {
            return ResponseValue.error((String)"\u83dc\u5355\u9879\u5fc5\u987b\u586b\u5199\uff1a\u7ec4\u4ef6\u8def\u5f84\uff08component\uff09");
        }
        this.menuService.save((BasePo)s_menu);
        this.menuCacheProvider.updateCacheData(s_menu.getMenu_id(), (Object)s_menu);
        BeanContextAware.publishEvent((ApplicationEvent)new RoleSecurityChangeEvent((Object)("menu:" + s_menu.getMenu_id())));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/add"})
    public ResponseValue saveAddMenu(@RequestBody S_menu s_menu) {
        if (s_menu == null || StringUtils.isEmpty((String)s_menu.getParent_id()) || StringUtils.isEmpty((String)s_menu.getMenu_name())) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        S_menu exist = this.menuService.queryExistMenuInParent(s_menu.getParent_id(), s_menu.getMenu_name());
        if (exist != null) {
            return ResponseValue.error((String)("\u7236\u83dc\u5355\u4e0b\u5df2\u6709\u76f8\u540c\u540d\u79f0\u83dc\u5355\u5b58\u5728:" + s_menu.getMenu_name()));
        }
        if (s_menu.getIs_frame() == 0 && !StringUtils.isHttpLink((String)s_menu.getPath())) {
            return ResponseValue.error((String)"\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934");
        }
        if (s_menu.getMenu_type().equals("C") && StringUtils.isEmpty((String)s_menu.getComponent())) {
            return ResponseValue.error((String)"\u83dc\u5355\u9879\u5fc5\u987b\u586b\u5199\uff1a\u7ec4\u4ef6\u8def\u5f84\uff08component\uff09");
        }
        s_menu.setMenu_id(DateUtils.getDateTimeSecondForShow());
        this.menuService.insert((BasePo)s_menu);
        S_menu saved = (S_menu)this.menuService.get((BasePo)new S_menu(s_menu.getMenu_id()));
        this.menuCacheProvider.putCacheData(s_menu.getMenu_id(), (Object)saved);
        BeanContextAware.publishEvent((ApplicationEvent)new RoleSecurityChangeEvent((Object)("menu:" + saved.getMenu_id())));
        return ResponseValue.success();
    }

    @RequestMapping(value={"/select/roleMenuTree/{roleId}"})
    public ResponseValue selectRoleMenuTree(@PathVariable Long roleId) {
        if (roleId == null || roleId <= 0L) {
            throw new IllegalArgumentException("\u89d2\u8272\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        HashMap<String, List> data = new HashMap<String, List>(4);
        List roleMenuIds = this.roleService.queryRoleMenuIdList(roleId.longValue());
        int menuScope = this.getCurrentOrgMenuScope();
        List menuTreeList = this.menuCacheProvider.getMenuTreeAll(null, true, menuScope);
        data.put("checkedKeys", roleMenuIds);
        data.put("menus", menuTreeList);
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/select/tree"})
    public ResponseValue selectMenuTree() {
        int menuScope = this.getCurrentOrgMenuScope();
        List menuTreeList = this.menuCacheProvider.getMenuTreeAll(null, true, menuScope);
        return ResponseValue.success((Object)menuTreeList);
    }

    @GetMapping(value={"/list"})
    public ResponseValue listMenuWithoutTree() {
        List menuList = null;
        UserPrincipal userPrincipal = this.getCurrentUserPrincipal();
        if (this.isSupervisor()) {
            menuList = this.menuCacheProvider.getMenuList(null, 0);
        } else {
            int menuScope = this.getCurrentOrgMenuScope();
            menuList = this.menuCacheProvider.getMenuList(userPrincipal.getRoleIdList(), menuScope);
        }
        return ResponseValue.success((Object)menuList);
    }
}

