/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.NotifyConstants;
import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.notify.InfoParam;
import com.iplatform.base.pojo.notify.NotificationParam;
import com.iplatform.base.service.NotificationServiceImpl;
import com.iplatform.base.util.NotificationUtils;
import com.iplatform.model.po.SfNotification;
import com.iplatform.model.po.SfTemplateMessage;
import com.iplatform.model.vo.NotificationConfigVo;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/platform/system/notification"})
public class NotificationController
extends SystemController {
    private NotificationServiceImpl notificationService;

    @Autowired
    public NotificationController(NotificationServiceImpl notificationService) {
        this.notificationService = notificationService;
    }

    @RequestMapping(value={"/sms/switch"}, method={RequestMethod.POST})
    public ResponseValue smsSwitch(Long id) {
        SfNotification notification = (SfNotification)this.notificationService.get((BasePo)new SfNotification(id));
        if (notification.getIsSms() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error((String)"\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u77ed\u4fe1");
        }
        if (notification.getIsSms() == NotifyConstants.SWITCH_OPEN) {
            notification.setIsSms(Integer.valueOf(NotifyConstants.SWITCH_COLSE));
        } else {
            notification.setIsSms(Integer.valueOf(NotifyConstants.SWITCH_OPEN));
        }
        this.notificationService.update((BasePo)notification);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/routine/switch"}, method={RequestMethod.POST})
    public ResponseValue routineSwitch(Long id) {
        SfNotification notification = (SfNotification)this.notificationService.get((BasePo)new SfNotification(id));
        if (notification.getIsRoutine() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error((String)"\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6a21\u677f");
        }
        if (notification.getIsRoutine() == NotifyConstants.SWITCH_OPEN) {
            notification.setIsRoutine(Integer.valueOf(NotifyConstants.SWITCH_COLSE));
        } else {
            notification.setIsRoutine(Integer.valueOf(NotifyConstants.SWITCH_OPEN));
        }
        this.notificationService.update((BasePo)notification);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/wechat/switch"}, method={RequestMethod.POST})
    public ResponseValue wechatSwitch(Long id) {
        SfNotification notification = (SfNotification)this.notificationService.get((BasePo)new SfNotification(id));
        if (notification.getIsWechat() == NotifyConstants.SWITCH_NOT_EXIST) {
            return ResponseValue.error((String)"\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u516c\u4f17\u53f7\u6a21\u677f");
        }
        if (notification.getIsWechat() == NotifyConstants.SWITCH_OPEN) {
            notification.setIsWechat(Integer.valueOf(NotifyConstants.SWITCH_COLSE));
        } else {
            notification.setIsWechat(Integer.valueOf(NotifyConstants.SWITCH_OPEN));
        }
        this.notificationService.update((BasePo)notification);
        return ResponseValue.success();
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public ResponseValue detail(InfoParam request) {
        if (request == null || request.getId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        long id = request.getId();
        SfNotification notification = (SfNotification)this.notificationService.get((BasePo)new SfNotification(Long.valueOf(id)));
        NotificationConfigVo vo = new NotificationConfigVo();
        SfTemplateMessage templateMessage = null;
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_WECHAT)) {
            if (notification.getIsWechat() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error((String)"\u8bf7\u5148\u914d\u7f6e\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f");
            }
            templateMessage = (SfTemplateMessage)this.notificationService.get((BasePo)new SfTemplateMessage(Long.valueOf(notification.getWechatId().longValue())));
            vo = NotificationUtils.acquireNotificationConfigVo((SfTemplateMessage)templateMessage);
            vo.setStatus(notification.getIsWechat());
        } else if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_ROUTINE)) {
            if (notification.getIsRoutine() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error((String)"\u8bf7\u5148\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f");
            }
            templateMessage = (SfTemplateMessage)this.notificationService.get((BasePo)new SfTemplateMessage(Long.valueOf(notification.getRoutineId().longValue())));
            vo = NotificationUtils.acquireNotificationConfigVo((SfTemplateMessage)templateMessage);
            vo.setStatus(notification.getIsRoutine());
        } else if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_SMS)) {
            if (notification.getIsSms() == NotifyConstants.SWITCH_NOT_EXIST) {
                return ResponseValue.error((String)"\u8bf7\u5148\u914d\u7f6e\u77ed\u4fe1\u6a21\u677f");
            }
            templateMessage = (SfTemplateMessage)this.notificationService.get((BasePo)new SfTemplateMessage(Long.valueOf(notification.getSmsId().longValue())));
            vo = NotificationUtils.acquireNotificationConfigVo((SfTemplateMessage)templateMessage);
            vo.setStatus(notification.getIsSms());
        }
        return ResponseValue.success((Object)vo);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ResponseValue list(NotificationParam param) {
        List data = null;
        data = param == null ? this.notificationService.queryList(null) : this.notificationService.queryList(param.getSendType());
        return ResponseValue.success((Object)data);
    }
}

