/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.pojo.log.OperateLogParam;
import com.iplatform.base.service.LogServiceImpl;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.web.ResponseValue;
import com.walker.web.log.BusinessType;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/operate_log"})
public class OperateLogController
extends SystemController {
    private LogServiceImpl logService;

    @Autowired
    public OperateLogController(LogServiceImpl logService) {
        this.logService = logService;
    }

    @RequestMapping(value={"/select/get_business_type"})
    public ResponseValue getBusinessTypeList() {
        ArrayList<KeyValue> data = new ArrayList<KeyValue>();
        for (BusinessType businessType : BusinessType.values()) {
            data.add(new KeyValue((Object)businessType.getIndex(), (Object)businessType.getName()));
        }
        return ResponseValue.success(data);
    }

    @RequestMapping(value={"/select/clean"})
    public ResponseValue clear() {
        this.logService.execClearOperateLog();
        return ResponseValue.success();
    }

    @RequestMapping(value={"/list"})
    public ResponseValue list(OperateLogParam operateLogParam) {
        GenericPager pager = null;
        pager = operateLogParam == null ? this.logService.queryPageOperateLogList(null, null, null, null) : this.logService.queryPageOperateLogList(operateLogParam.getOperName(), operateLogParam.getBusinessType(), operateLogParam.getStatus(), operateLogParam.getTitile());
        return ResponseValue.success((Object)pager);
    }
}

