/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.PlatformUserCallback;
import com.iplatform.base.SystemController;
import com.iplatform.base.di.JdbcExcelDataImportor;
import com.iplatform.base.excel.UserDataImportor;
import com.iplatform.base.pojo.UserParam;
import com.iplatform.base.service.LoginServiceImpl;
import com.iplatform.base.service.RoleServiceImpl;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.UserUtils;
import com.iplatform.base.util.user.SystemUser;
import com.iplatform.model.po.S_user_core;
import com.walker.db.page.GenericPager;
import com.walker.di.DataImportException;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.DateUtils;
import com.walker.infrastructure.utils.NumberGenerator;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import com.walker.web.log.BusinessType;
import com.walker.web.log.Log;
import com.walker.web.log.OperateUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/user"})
public class UserController
extends SystemController {
    private UserServiceImpl userService;
    private RoleServiceImpl roleService;
    private LoginServiceImpl loginService;
    private UserOnlineProvider userOnlineProvider;

    @Autowired
    public UserController(UserServiceImpl userService, RoleServiceImpl roleService, LoginServiceImpl loginService, UserOnlineProvider userOnlineProvider) {
        this.userService = userService;
        this.roleService = roleService;
        this.loginService = loginService;
        this.userOnlineProvider = userOnlineProvider;
    }

    @PostMapping(value={"/import"})
    public ResponseValue importExcel(MultipartFile file, boolean updateSupport) {
        try {
            UserDataImportor dataImportor = new UserDataImportor(file.getInputStream());
            dataImportor.setId("user_import");
            this.getDataImportEngine().executeImport((JdbcExcelDataImportor)dataImportor, this.getCurrentUserPrincipal().getUserName());
            this.logger.info("\u6210\u529f\u5bfc\u5165\u8bb0\u5f55:{}", (Object)dataImportor.getSuccessSize());
            this.logger.info("\u9519\u8bef\u7ed3\u679c\u6587\u4ef6:{}", (Object)dataImportor.getErrorFile());
            FileInfo errorFileInfo = this.uploadFileToRemote(dataImportor.getErrorFile(), null, String.valueOf(this.getOwner()));
            if (errorFileInfo != null) {
                this.logger.debug("\u7528\u6237\u5bfc\u5165\u5b58\u5728'\u4e0d\u7b26\u5408\u6570\u636e': \uff0c", (Object)errorFileInfo.toString());
                this.logger.debug("\u8fd9\u91cc\u53ef\u4ee5\u8fd4\u56de\u7ed9\u524d\u7aef\uff0c\u8ba9\u524d\u7aef\u70b9\u51fb\u94fe\u63a5\u4e0b\u8f7d!");
            }
            return ResponseValue.success();
        }
        catch (Exception e) {
            if (e instanceof DataImportException) {
                return ResponseValue.error((String)("\u5bfc\u5165\u51fa\u73b0\u5f02\u5e38:" + e.getMessage()));
            }
            this.logger.error("io\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            return ResponseValue.error((String)("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38:" + e.getMessage()));
        }
    }

    @PostMapping(value={"/select/downloadTemplate"})
    public void downloadTemplate() {
        this.downloadLocalImportTemplate("s_user_core");
    }

    @PostMapping(value={"/select/saveAuthRole"})
    public ResponseValue updateAuthRole(Long userId, Long[] roleIds) {
        if (userId == null || userId <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.userService.execUpdateAuthRole(userId.longValue(), roleIds);
        this.logger.error("\u66f4\u65b0\u7528\u6237\u5f52\u5c5e\u89d2\u8272\u540e\uff0c\u9700\u8981\u66f4\u65b0\u7528\u6237\u767b\u5f55\u7f13\u5b58\u4e2d\u89d2\u8272\u5217\u8868\uff0c\u8bb0\u4f4f\u4fee\u6539\u4ee3\u7801!");
        String uuid = this.loginService.queryLoginUUID(userId.longValue());
        if (StringUtils.isNotEmpty((String)uuid)) {
            ArrayList<String> roleIdList = new ArrayList<String>(4);
            Long[] longArray = roleIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long roleId = longArray[i];
                roleIdList.add(String.valueOf(roleId));
            }
            DefaultUserPrincipal userPrincipal = new DefaultUserPrincipal(this.getUser(userId));
            userPrincipal.setRoleIdList(roleIdList);
            this.userOnlineProvider.cacheUserPrincipal(uuid, (UserPrincipal)userPrincipal);
        } else {
            this.logger.debug("\u7528\u6237\u4ece\u672a\u767b\u5f55\u8fc7\uff0c\u4e0d\u66f4\u65b0\u767b\u5f55uuid\u4fe1\u606f\uff0cuserId={}", (Object)userId);
        }
        return ResponseValue.success();
    }

    @GetMapping(value={"/select/authRole/{userId}"})
    public ResponseValue authRole(@PathVariable Long userId) {
        List userAuthRoleList = this.userService.queryAuthRoleList(this.getUserRootOrgId(userId), userId.longValue());
        HashMap data = new HashMap(4);
        data.put("roles", userAuthRoleList);
        data.put("user", this.getUserCacheProvider().getUser(userId.longValue()));
        return ResponseValue.success(data);
    }

    @PostMapping(value={"/resetPwd"})
    public ResponseValue resetPassword(@RequestBody SystemUser systemUser) {
        if (systemUser == null || systemUser.getId() == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        String initPassword = this.getArgumentVariable("security.password.init").getStringValue();
        this.userService.execResetPassword(systemUser.getId().longValue(), initPassword);
        S_user_core user_core = (S_user_core)this.userService.get((BasePo)new S_user_core(systemUser.getId()));
        this.getUserCacheProvider().updateUser(user_core);
        return ResponseValue.success();
    }

    @GetMapping(value={"/remove/{userId}"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.Delete, isSaveRequestData=true, isSaveResponseData=true)
    public ResponseValue deleteUser(@PathVariable Long userId) {
        if (userId == null || userId <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.userService.execDeleteUser(userId.longValue(), (PlatformUserCallback)this.getPlatformCallback(PlatformUserCallback.class));
        this.getUserCacheProvider().removeUser(userId.longValue());
        this.logger.info("\u5220\u9664\u4e00\u4e2a\u7528\u6237\uff0c\u7f13\u5b58\u5df2\u66f4\u65b0:" + userId);
        return ResponseValue.success();
    }

    @PostMapping(value={"/edit"})
    public ResponseValue editUser(@RequestBody SystemUser user_core) {
        if (user_core == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)user_core.getUser_name()) || StringUtils.isEmpty((String)user_core.getNick_name())) {
            return ResponseValue.error((String)"\u7f3a\u5c11: \u767b\u5f55ID\u6216\u7528\u6237\u6635\u79f0");
        }
        if (user_core.getUser_name().equals("supervisor")) {
            return ResponseValue.error((String)"\u65e0\u6cd5\u4f7f\u7528\u8be5\u7528\u6237\u540d");
        }
        S_user_core existUser = null;
        String phoneNumber = user_core.getPhonenumber();
        if (StringUtils.isNotEmpty((String)phoneNumber) && (existUser = this.userService.queryUserByPhone(phoneNumber)) != null && existUser.getId().longValue() != user_core.getId().longValue()) {
            return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u73b0\u6709\u7528\u6237\u4f7f\u7528");
        }
        String email = user_core.getEmail();
        if (StringUtils.isNotEmpty((String)email) && (existUser = this.userService.queryUserByEmail(email)) != null && existUser.getId().longValue() != user_core.getId().longValue()) {
            return ResponseValue.error((String)"\u8be5\u90ae\u7bb1\u5730\u5740\u5df2\u88ab\u73b0\u6709\u7528\u6237\u4f7f\u7528");
        }
        this.userService.execUpdateUser(user_core.$clone(), user_core.getRoleIds(), (PlatformUserCallback)this.getPlatformCallback(PlatformUserCallback.class));
        this.getUserCacheProvider().updateUser((S_user_core)user_core);
        this.logger.info("\u7f16\u8f91\u7528\u6237\u6210\u529f\uff0c\u5e76\u66f4\u65b0\u7f13\u5b58: " + user_core.getUser_name());
        return ResponseValue.success();
    }

    @PostMapping(value={"/select/changeStatus"})
    public ResponseValue changeStatus(@RequestBody SystemUser systemUser) {
        if (systemUser == null || systemUser.getId() == null || systemUser.getStatus() == null) {
            return ResponseValue.error((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        this.userService.execUpdateUserStatus(systemUser.getId().longValue(), systemUser.getStatus().intValue());
        S_user_core user_core = (S_user_core)this.userService.get((BasePo)new S_user_core(systemUser.getId()));
        this.getUserCacheProvider().updateUser(user_core);
        return ResponseValue.success();
    }

    @PostMapping(value={"/add"})
    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.Insert, operatorType=OperateUser.Manage)
    public ResponseValue saveUser(@RequestBody SystemUser user_core) {
        if (user_core == null) {
            return ResponseValue.error((String)"\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)user_core.getUser_name()) || StringUtils.isEmpty((String)user_core.getNick_name())) {
            return ResponseValue.error((String)"\u7f3a\u5c11: \u767b\u5f55ID\u6216\u7528\u6237\u6635\u79f0");
        }
        if (user_core.getUser_name().equals("supervisor")) {
            return ResponseValue.error((String)"\u65e0\u6cd5\u4f7f\u7528\u8be5\u7528\u6237\u540d");
        }
        S_user_core existUser = this.userService.queryUserByLoginId(user_core.getUser_name());
        if (existUser != null) {
            return ResponseValue.error((String)"\u767b\u5f55\u540d\u5df2\u5b58\u5728");
        }
        String encryptInitPass = null;
        encryptInitPass = StringUtils.isEmpty((String)user_core.getPassword()) ? this.getArgumentVariable("security.password.init").getStringValue() : this.encryptPassword(user_core.getPassword());
        user_core.setPassword(encryptInitPass);
        String phoneNumber = user_core.getPhonenumber();
        if (StringUtils.isNotEmpty((String)phoneNumber) && this.userService.queryUserByPhone(phoneNumber) != null) {
            return ResponseValue.error((String)"\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u73b0\u6709\u7528\u6237\u4f7f\u7528");
        }
        String email = user_core.getEmail();
        if (StringUtils.isNotEmpty((String)email) && this.userService.queryUserByEmail(email) != null) {
            return ResponseValue.error((String)"\u8be5\u90ae\u7bb1\u5730\u5740\u5df2\u88ab\u73b0\u6709\u7528\u6237\u4f7f\u7528");
        }
        user_core.setCreate_time(Long.valueOf(DateUtils.getDateTimeNumber((long)System.currentTimeMillis())));
        user_core.setCreate_by(this.getCurrentUser().getUser_name());
        user_core.setOrg_id(Long.valueOf(this.getRootOrgIdByDept(user_core.getDept_id())));
        user_core.setId(Long.valueOf(NumberGenerator.getLongSequenceNumber()));
        this.userService.execSaveUser(user_core.$clone(), user_core.getRoleIds(), (PlatformUserCallback)this.getPlatformCallback(PlatformUserCallback.class));
        this.getUserCacheProvider().putUser((S_user_core)user_core);
        this.logger.info("\u6dfb\u52a0\u4e00\u4e2a\u7528\u6237\u6210\u529f\uff0c\u7f13\u5b58\u5df2\u52a0\u5165: " + user_core.getUser_name());
        return ResponseValue.success();
    }

    @GetMapping(value={"/select/role/{deptId}"})
    public ResponseValue getNewUserRoles(@PathVariable Long deptId) {
        long orgId = 0L;
        orgId = deptId == null || deptId == 0L ? this.getCurrentUser().getOrg_id().longValue() : this.getRootOrgIdByDept(deptId);
        List roleList = this.roleService.queryRoleList(orgId);
        HashMap<String, List> data = new HashMap<String, List>(4);
        data.put("roles", roleList);
        return ResponseValue.success(data);
    }

    @GetMapping(value={"/view/{userId}"})
    public ResponseValue getUserInfo(@PathVariable Long userId) {
        if (userId == null || userId <= 0L) {
            return ResponseValue.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        long orgId = this.getUserCacheProvider().getUser(userId.longValue()).getOrg_id();
        List roleList = this.roleService.queryRoleList(orgId);
        List roleIds = this.userService.queryUserRoleIdList(userId.longValue());
        HashMap data = new HashMap(4);
        data.put("roles", roleList);
        data.put("roleIds", UserUtils.toRoleIdLongList((List)roleIds));
        data.put("data", this.getUserCacheProvider().getUser(userId.longValue()));
        return ResponseValue.success(data);
    }

    @GetMapping(value={"/list"})
    public ResponseValue list(UserParam userParam) {
        GenericPager pager;
        List data;
        if (userParam == null) {
            return ResponseValue.error((String)"\u65e0\u6cd5\u67e5\u8be2\u7528\u6237:\u6ca1\u6709\u6761\u4ef6");
        }
        long orgId = 0L;
        long deptId = userParam.getDeptId();
        if (!this.isSupervisor()) {
            orgId = this.getCurrentUser().getOrg_id();
        } else {
            if (deptId <= 0L) {
                return ResponseValue.error((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u673a\u6784\u67e5\u8be2");
            }
            orgId = this.getRootOrgIdByDept(deptId);
        }
        if (orgId == deptId) {
            deptId = 0L;
        }
        if (!StringUtils.isEmptyList((List)(data = (pager = this.userService.queryPageUserList(orgId, deptId, userParam.getUserName(), userParam.getPhonenumber(), userParam.getStatus())).getDatas()))) {
            data.stream().forEach(p -> p.setParameterString("dept_name", this.getDeptName(p.getDept_id())));
        }
        return ResponseValue.success((Object)pager);
    }
}

