/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.controller;

import com.iplatform.base.SystemController;
import com.iplatform.base.callback.UserProfileCallback;
import com.iplatform.base.config.SecurityUserProperties;
import com.iplatform.base.pojo.UserInfoRequest;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.PlatformRSAUtils;
import com.iplatform.core.BeanContextAware;
import com.iplatform.core.TokenAwareContext;
import com.iplatform.core.TokenEntity;
import com.iplatform.model.po.S_user_core;
import com.iplatform.model.po.S_user_login;
import com.walker.file.FileInfo;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.BasePo;
import com.walker.web.ResponseValue;
import com.walker.web.UserOnlineProvider;
import com.walker.web.UserPrincipal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/user/profile"})
public class UserProfileController
extends SystemController {
    private UserServiceImpl userService;
    private SecurityUserProperties securityUserProperties;

    @Autowired
    public UserProfileController(UserServiceImpl userService, SecurityUserProperties securityUserProperties) {
        this.userService = userService;
        this.securityUserProperties = securityUserProperties;
    }

    @GetMapping
    public ResponseValue index() {
        List roleIdList = this.getCurrentUserPrincipal().getRoleIdList();
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("user", this.getCurrentUser());
        if (!StringUtils.isEmptyList((List)roleIdList)) {
            data.put("roleGroup", StringUtils.collectionToCommaDelimitedString((Collection)roleIdList));
        } else {
            data.put("roleGroup", "");
        }
        return ResponseValue.success(data);
    }

    @PostMapping(value={"/avatar"})
    public ResponseValue avatar(MultipartFile file) {
        if (file == null) {
            return ResponseValue.error((String)"\u4e0a\u4f20\u5934\u50cf\u4e3a\u7a7a");
        }
        long userId = this.getCurrentUserId();
        try {
            FileInfo fileInfo = this.uploadFileToRemote(file.getInputStream(), "avatar.jpg", String.valueOf(userId), file.getSize(), null, String.valueOf(-1));
            S_user_core s_user_core = new S_user_core(Long.valueOf(userId));
            s_user_core.setAvatar(fileInfo.getId());
            this.userService.save((BasePo)s_user_core);
            S_user_core cacheUser = this.getUserCacheProvider().getUser(userId);
            cacheUser.setAvatar(fileInfo.getId());
            this.getUserCacheProvider().updateUser(cacheUser);
            return ResponseValue.success((String)"success", (Object)"imageUrl");
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u5934\u50cf\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            return ResponseValue.error((String)"\u5934\u50cf\u5904\u7406\u5f02\u5e38!");
        }
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    public ResponseValue updateNameAndPassword(@RequestBody UserInfoRequest request) {
        if (request == null) {
            return ResponseValue.error((String)"\u8bf7\u586b\u5199\u66f4\u65b0\u8d44\u6599");
        }
        if (StringUtils.isEmpty((String)request.getRealName()) && StringUtils.isEmpty((String)request.getPassword())) {
            return ResponseValue.error((String)"\u672a\u586b\u5199\u4efb\u4f55\u8d44\u6599");
        }
        S_user_core currentUser = this.getCurrentUser();
        if (StringUtils.isNotEmpty((String)request.getPassword())) {
            String originPassword = PlatformRSAUtils.getRsaDecryptValue((String)request.getPassword(), (String)"MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAN98n0pzMheL6exr\nZKJvesudnlHKGVjl6cSFlNBzUZxN5lvqCq7gegMlXqWyR97FI0JQL/eaY2Paeu5Y\naBGDqJUIAwFR/mgy/mdWoiFnl1q/LVRn3K/AvT7JWEFJeZqZSZ7NCWHQfdyVQjU3\ncdz1oKK6UHpEwiy/Vq6QGRMGGBBlAgMBAAECgYBEyOuSE5CIVMTjwk4P/LXTs6iF\nzektRl5D4UVjPwsQS52qDofJOUf0be0KnKuoMg7fGyUYVUlf81/Aui8VrOsWmEbU\n8XL41Pi3m6EWWGeWE1/5q+j29jxYrrhfBcpBH/4fBKMhiNJ+jnJ2bH+TpngRwpNe\nnVIfxRU5FdHOL3WNIQJBAPKGUSOgynf82LEQfvpzzp8gqhGMVbnVIqtezUNPQyK2\nda7ryWYP88SE38JhB6GlM6bimCWRgIzodydccuJTd50CQQDr54J5upPlMsR3im0Q\nqCeVbrGfn+DO226cZMaUhbVwxY7xy4ewXyt4yY6vBxwYX7GYs24jZPKekyWDeqr2\nUrVpAkBmXJSwkfQC8sBO86R0dx6VgUbmwzGHjtLkO84tA65VX2eKXdCSeFct8dsz\ngpqi+kQzwt3utVvpnVB1V4rRxeLtAkEAm/2SQXwmn8BaOdHHHOSUiDOSMMM/nIlt\nMu1QgpWHzPJV+31iVDYaQNzHBOXmphdhEGBVzAHMjR8wByjuM8OtQQJBAM8pK710\nJC6YzfchqlNMFRh6kieWEx+o+aoWtL0EmeHB56nF96QHPW09UAP2VRUdadgSD+1w\nZmw/rOnAk8t/ryg=");
            String error = this.validatePasswordRule(originPassword);
            if (error != null) {
                return ResponseValue.error((String)error);
            }
            request.setPassword(this.encryptPassword(originPassword));
            currentUser.setPassword(request.getPassword());
            currentUser.setModify_pwd(Integer.valueOf(1));
        }
        if (StringUtils.isNotEmpty((String)request.getRealName())) {
            currentUser.setNick_name(request.getRealName());
        }
        UserProfileCallback callback = (UserProfileCallback)this.getPlatformCallback(UserProfileCallback.class);
        this.getUserService().execUpdateUserInfo(request, currentUser.getId().longValue(), callback);
        this.getUserCacheProvider().updateUser(currentUser);
        this.logger.debug(TokenAwareContext.getCurrentToken().toString());
        return ResponseValue.success();
    }

    @RequestMapping(value={"/force_change_pass"}, method={RequestMethod.POST})
    public ResponseValue forceChangePassword(String encryptPassword) {
        if (StringUtils.isEmpty((String)encryptPassword)) {
            return ResponseValue.error((String)"\u5fc5\u987b\u586b\u5199\u4fee\u6539\u5bc6\u7801\u5185\u5bb9");
        }
        String originPassword = PlatformRSAUtils.getRsaDecryptValue((String)encryptPassword, (String)"MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAN98n0pzMheL6exr\nZKJvesudnlHKGVjl6cSFlNBzUZxN5lvqCq7gegMlXqWyR97FI0JQL/eaY2Paeu5Y\naBGDqJUIAwFR/mgy/mdWoiFnl1q/LVRn3K/AvT7JWEFJeZqZSZ7NCWHQfdyVQjU3\ncdz1oKK6UHpEwiy/Vq6QGRMGGBBlAgMBAAECgYBEyOuSE5CIVMTjwk4P/LXTs6iF\nzektRl5D4UVjPwsQS52qDofJOUf0be0KnKuoMg7fGyUYVUlf81/Aui8VrOsWmEbU\n8XL41Pi3m6EWWGeWE1/5q+j29jxYrrhfBcpBH/4fBKMhiNJ+jnJ2bH+TpngRwpNe\nnVIfxRU5FdHOL3WNIQJBAPKGUSOgynf82LEQfvpzzp8gqhGMVbnVIqtezUNPQyK2\nda7ryWYP88SE38JhB6GlM6bimCWRgIzodydccuJTd50CQQDr54J5upPlMsR3im0Q\nqCeVbrGfn+DO226cZMaUhbVwxY7xy4ewXyt4yY6vBxwYX7GYs24jZPKekyWDeqr2\nUrVpAkBmXJSwkfQC8sBO86R0dx6VgUbmwzGHjtLkO84tA65VX2eKXdCSeFct8dsz\ngpqi+kQzwt3utVvpnVB1V4rRxeLtAkEAm/2SQXwmn8BaOdHHHOSUiDOSMMM/nIlt\nMu1QgpWHzPJV+31iVDYaQNzHBOXmphdhEGBVzAHMjR8wByjuM8OtQQJBAM8pK710\nJC6YzfchqlNMFRh6kieWEx+o+aoWtL0EmeHB56nF96QHPW09UAP2VRUdadgSD+1w\nZmw/rOnAk8t/ryg=");
        String error = this.validatePasswordRule(originPassword);
        if (error != null) {
            return ResponseValue.error((String)error);
        }
        long userId = this.getCurrentUserId();
        this.getUserService().execForceChangePassword(userId, this.encryptPassword(originPassword));
        S_user_core userCore = (S_user_core)this.getUserService().get((BasePo)new S_user_core(Long.valueOf(userId)));
        this.getUserCacheProvider().updateUser(userCore);
        String uuid = null;
        UserPrincipal userPrincipal = null;
        UserOnlineProvider userOnlineProvider = (UserOnlineProvider)BeanContextAware.getBeanByType(UserOnlineProvider.class);
        TokenEntity tokenEntity = TokenAwareContext.getCurrentToken();
        if (tokenEntity != null) {
            uuid = tokenEntity.getUuid();
            userPrincipal = userOnlineProvider.getUserPrincipal(uuid);
        } else {
            this.logger.debug("TokenAwareContext \u672a\u83b7\u53d6\u5230token\u4fe1\u606f\uff0c\u9700\u8981\u4ece\u767b\u5f55\u7f13\u5b58\u4e2d\u67e5\u8be2\uff0cuserId={}", (Object)userId);
            S_user_login user_login = this.getLoginStrategyManager().getUserLogin(userCore.getUser_name());
            if (user_login == null) {
                this.logger.warn("\u7528\u6237\u5df2\uff08\u5f3a\u5236\uff09\u4fee\u6539\u5bc6\u7801\uff0c\u4f46\u672a\u627e\u5230\u767b\u5f55\u7f13\u5b58(user_login)\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\uff0cuser = {}", (Object)userCore.getUser_name());
                throw new IllegalStateException("");
            }
            uuid = user_login.getUuid();
            userPrincipal = userOnlineProvider.getUserPrincipal(uuid);
        }
        ((S_user_core)userPrincipal.getUserInfo()).setModify_pwd(Integer.valueOf(1));
        userOnlineProvider.cacheUserPrincipal(uuid, userPrincipal);
        this.logger.debug("\u5bc6\u7801\u5df2\u4fee\u6539\uff0cuserId={}", (Object)userId);
        return ResponseValue.success();
    }
}

