/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.base.excel;

import com.iplatform.base.di.JdbcExcelDataImportor;
import com.iplatform.base.util.DataImportUtils;
import com.walker.di.UpdateResult;
import com.walker.di.UpdateType;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class UserDataImportor
extends JdbcExcelDataImportor {
    private static final String SQL_QUERY = "select * from s_user_core where user_name in (:userName)";

    public UserDataImportor(InputStream inputStream) {
        this.setBatchEnabled();
        this.setBatchSleepMills(200L);
        this.setUpdateType(UpdateType.Override);
        this.setSource(inputStream);
    }

    protected String acquireTableName() {
        return "s_user_core";
    }

    protected boolean isCheckDataExist() {
        return true;
    }

    protected UpdateResult checkDataExist(String tableName, List<Map<String, Object>> mapList) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        List paramUserName = DataImportUtils.acquireWhereInStringValues((String)"user_name", mapList);
        sqlParameterSource.addValue("userName", (Object)paramUserName);
        List existList = this.getDataImportService().queryListObjectWhereIn(SQL_QUERY, (SqlParameterSource)sqlParameterSource);
        if (!StringUtils.isEmptyList((List)existList) && this.logger.isDebugEnabled()) {
            for (Map existOne : existList) {
                this.logger.debug("\u5b58\u5728\u4e00\u6761\u6570\u636e = " + existOne);
            }
        }
        UpdateResult updateResult = new UpdateResult();
        List<String> whereColumnNames = Arrays.asList("user_name");
        Object[] result = DataImportUtils.calculateInsertAndUpdateList(mapList, (List)existList, whereColumnNames);
        List insertList = (List)result[0];
        List updateList = (List)result[1];
        updateResult.setInsertList(insertList);
        if (this.getUpdateType() == UpdateType.Override) {
            updateResult.setUpdateColumnNames(Arrays.asList("dept_id", "org_id", "nick_name", "user_type", "email", "phonenumber", "sex"));
            updateResult.setWhereColumnNames(whereColumnNames);
            updateResult.setUpdateList(updateList);
        }
        return updateResult;
    }

    protected String validateData(Map<String, String> data) {
        if (data.get("user_name") == null) {
            return "\u767b\u5f55\u540d\u4e0d\u5b58\u5728";
        }
        if (data.get("nick_name") == null) {
            return "\u6635\u79f0\u4e0d\u5b58\u5728";
        }
        if (data.get("user_type") == null) {
            return "\u7528\u6237\u7c7b\u578b\u4e0d\u5b58\u5728";
        }
        String phoneNumber = data.get("phonenumber");
        if (StringUtils.isNotEmpty((String)phoneNumber) && !PhoneNumberUtils.isCellPhoneNumber((String)phoneNumber)) {
            return "\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef";
        }
        return null;
    }
}

