package com.iplatform.security;

import com.iplatform.base.pojo.RequestLogin;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

/**
 * 重写默认的认证token对象，添加自定义属性。
 * @author 时克英
 * @date 2023-01-27
 */
public class DefaultAuthenticationToken extends UsernamePasswordAuthenticationToken {

    private RequestLogin requestLogin;

    /**
     * 返回请求登录提交的原始数据
     * @return
     */
    public RequestLogin getRequestLogin() {
        return requestLogin;
    }

    public DefaultAuthenticationToken(Object principal, Object credentials) {
        super(principal, credentials);
    }

    public DefaultAuthenticationToken(Object principal, Object credentials, RequestLogin requestLogin){
        super(principal, credentials);
        this.requestLogin = requestLogin;
    }
}
