package com.iplatform.security;

import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import com.walker.web.UserType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Spring Security 定义的用户细节对象，在认证以及过滤权限时使用。
 * @author 时克英
 * @date 2022-10-31
 */
public class DefaultUserDetails implements UserDetails {

    private List<GrantedAuthority> grantedList = new ArrayList<GrantedAuthority>(4);
    private List<String> roleIdList = new ArrayList<>(4);   // 用户包含角色ID集合，增加冗余看前端是否需要

    private UserPrincipal<S_user_core> userPrincipal = null;

    public DefaultUserDetails(UserPrincipal<S_user_core> userPrincipal){
        if(userPrincipal == null){
            throw new IllegalArgumentException("UserPrincipal is required!");
        }
        this.userPrincipal = userPrincipal;
    }

    public UserPrincipal<S_user_core> getUserPrincipal(){
        return this.userPrincipal;
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedList;
    }

    @Override
    public String getPassword() {
        return this.userPrincipal.getPassword();
    }

    @Override
    public String getUsername() {
        return this.userPrincipal.getUserName();
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return !this.userPrincipal.isAccountLocked();
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.userPrincipal.isEnabled();
    }

    /**
     * 返回用户包含的角色ID集合。
     * @return
     * @date 2022-11-11
     */
    public List<String> getRoleIdList(){
        return this.roleIdList;
    }

    /**
     * 把角色ID集合也存入principal，因为该对象会放入缓存，而 UserDetails 不会。
     * @date 2022-11-11
     */
    public void setRoleIdListToPrincipal(){
        this.userPrincipal.setRoleIdList(this.roleIdList);
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 遗留代码，看是否能用上。2022-10-31
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public boolean isSupervisor(){
        return this.userPrincipal.getUserInfo().getUser_type() == UserType.TYPE_SUPER;
    }

    private static final Map<String, GrantedAuthority> gas = new HashMap<String, GrantedAuthority>(3);

    public void addGrantedAuthority(String roleName){
//		if(roleName != null
//				&& (roleName.equals(ROLE_SUPER_ADMIN) || roleName.equals(ROLE_ADMIN)
//						|| roleName.equals(ROLE_USER))){
//			this.grantedList.add(gas.get(roleName));
//		}
        if(StringUtils.isNotEmpty(roleName)){
            GrantedAuthority ga = gas.get(roleName);
            if(ga == null){
                ga = new SimpleGrantedAuthority(roleName);
                gas.put(roleName, ga);
            }
            this.grantedList.add(ga);

            //
            if(!this.roleIdList.contains(roleName)){
                this.roleIdList.add(roleName);
            }
        }
    }

    public boolean equals(Object o){
        if(o == null) return false;
        if(o == this) return true;
        if(o instanceof DefaultUserDetails){
            DefaultUserDetails _o = (DefaultUserDetails)o;
            if(_o.getUsername().equals(this.getUsername())
                    && _o.getPassword().equals(this.getPassword())
                    && _o.isEnabled() == this.isEnabled()){
                return true;
            }
        }
        return false;
    }

    public int hashCode(){
        int result = 31;
        return result + 31*this.getUsername().hashCode()
                + this.getPassword().hashCode() + 31*(this.isEnabled() ? 1 : 0);
    }

    private String ip;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

//    private UserDiagram uerDiagram;
//
//    /**
//     * 返回用户具有的菜单权限图信息。
//     * @return
//     */
//    public UserDiagram getUerDiagram() {
//        return uerDiagram;
//    }
//
//    public void setUerDiagram(UserDiagram uerDiagram) {
//        this.uerDiagram = uerDiagram;
//    }

    @Override
    public String toString(){
        return new StringBuilder().append("[userDetails, name=").append(this.getUsername()).append("]").toString();
    }
}
