package com.iplatform.security.callback;

import com.iplatform.base.callback.GeneralLoginCallback;
import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;

/**
 * <s>PC端网页登录回调实现。</s><p></p>
 * 用户名密码登录方式回调实现。
 * @author 时克英
 * @date 2023-01-26
 * @date 2023-01-28 用户名、密码方式登录的回调实现。
 * @date 2023-04-07 重构名字为'明文密码'登录回调实现。参考：{@linkplain EncryptPasswordLoginCallback}
 */
public class SimplePasswordLoginCallback extends GeneralLoginCallback {

    @Deprecated
    @Override
    public Object[] queryLoginUser(String loginId) {
        return this.userService.queryLoginUser(loginId, false);
    }

    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
        Authentication usernamePasswordAuthenticationToken = SecurityContextHolder.getContext().getAuthentication();
        String password = usernamePasswordAuthenticationToken.getCredentials().toString();
        logger.debug("用户输入：" + password + ", " + userPrincipal.getPassword());
        return this.passwordEncoder.matches(password, userPrincipal.getPassword());
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    protected PasswordEncoder passwordEncoder = null;
}
