package com.iplatform.security.callback;

import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;

/**
 * 第三方对接登录回调实现。
 * <pre>
 *     1)该实现目前仅为预算一体化对接实验用，具体需要看后面更多情况。
 *     2)对接无需验证码，并且采用密码明文方式，因为都是后台操作，不存在风险。
 * </pre>
 * @author 时克英
 * @date 2023-07-03
 */
public class ThirdPartyLoginCallback extends SimplePasswordLoginCallback{

    @Override
    public boolean isValidateCaptcha() {
        // 第三方对接，无验证码。暂时为预算一体化对接使用。
        return false;
    }

    /**
     * 第三方（无需）验证密码。
     * @param userPrincipal
     * @return
     * @date 2023-10-23 新添加方法，重写验证密码，由于第三方会给我们用户信息，这里一般不需要验证密码。
     */
    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
        return true;
    }
}
