package com.iplatform.security.callback;

import com.iplatform.model.po.S_user_core;
import com.walker.web.UserPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * 微信授权登录，目前公众号H5自动登录使用。
 * <pre>
 *     1)前端处理微信对接获取accessToken;
 *     2)调用后台接口登录，后台组织参数，密码从数据库查询出来，
 *     3)因此密码直接就是加密的，直接比对就行（相等的）
 * </pre>
 * @author 时克英
 * @date 2023-07-27
 */
public class WechatLoginCallback extends SimplePasswordLoginCallback{

    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
        Authentication usernamePasswordAuthenticationToken = SecurityContextHolder.getContext().getAuthentication();
        String password = usernamePasswordAuthenticationToken.getCredentials().toString();
        logger.debug("用户输入：" + password + ", " + userPrincipal.getPassword());
        // 微信登录，传过来的密码就是数据库中查询的，因为后台代码调用登录！
        return password.equals(userPrincipal.getPassword());
    }

    @Override
    public boolean isValidateCaptcha() {
        // 无验证码。
        return false;
    }
}
