package com.iplatform.security.util;

import com.iplatform.base.captcha.JigsawCaptchaProvider;
import com.iplatform.base.captcha.NoneCaptchaProvider;
import com.iplatform.security.config.SecurityProperties;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import com.walker.web.ClientType;
import com.walker.web.captcha.SlideCaptchaProvider;

public class SecurityConfigUtils {

    /**
     * 根据设备类型，返回token失效时间（分钟）
     * @param clientType
     * @param securityProperties
     * @return
     * @date 2023-03-28
     */
    public static final long getTokenExpireMinutes(String clientType, SecurityProperties securityProperties){
        if(clientType.equals(ClientType.INDEX_PC)){
            return securityProperties.getTokenExpireWeb();
        } else {
            return securityProperties.getTokenExpireMobile();
        }
    }

    /**
     * 根据'登录回调方式'查找需要装配的'验证码类型'。
     * @param loginCaptchaUserPass
     * @param smsCaptchaProvider
     * @param imageCaptchaProvider
     * @return
     * @date 2023-03-14
     */
    public static final CaptchaProvider<CaptchaResult> findCaptchaProvider(String loginCaptchaUserPass
            , CaptchaProvider<CaptchaResult> smsCaptchaProvider
            , CaptchaProvider<CaptchaResult> imageCaptchaProvider
            , JigsawCaptchaProvider jigsawCaptchaProvider){
        CaptchaProvider<CaptchaResult> captchaProvider = null;
        CaptchaType captchaType = CaptchaType.getType(loginCaptchaUserPass);
        if(captchaType == CaptchaType.InputCode){
            captchaProvider = imageCaptchaProvider;
        } else if(captchaType == CaptchaType.SmsCode){
            captchaProvider = smsCaptchaProvider;
        } else if(captchaType == CaptchaType.Slide){
            captchaProvider = new SlideCaptchaProvider();
        } else if(captchaType == CaptchaType.Jigsaw){
            captchaProvider = jigsawCaptchaProvider;
        } else if(captchaType == CaptchaType.None){
            captchaProvider = new NoneCaptchaProvider();
        } else {
            throw new UnsupportedOperationException("不支持的CaptchaType:" + loginCaptchaUserPass);
        }
        return captchaProvider;
    }
}
