/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.UserLoginCache;
import com.iplatform.base.callback.AfterLoginCallback;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.base.util.TokenUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class DefaultLogoutSuccessHandler
implements LogoutSuccessHandler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserOnlineProvider userOnlineProvider;
    private TokenGenerator tokenGenerator;
    private UserLoginCache userLoginCache;

    public void setUserLoginCache(UserLoginCache userLoginCache) {
        this.userLoginCache = userLoginCache;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setUserOnlineProvider(UserOnlineProvider userOnlineProvider) {
        this.userOnlineProvider = userOnlineProvider;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String token = TokenUtils.getAuthorizationToken((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)token)) {
            try {
                String data = this.tokenGenerator.validateToken(token, "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwjSuSa2u2LZCTiezvUYPzfZmBgoNgsMPT4hc6HN7+h57fEjp2/RW1vmzvQf9cLgM3D37+x1VOXi+SvMXS3+wPsA8dU0hdZwcwRP+Y1AvWozhIISPYBcov8V9xMQnPLkbAVdaO2FFDl9rGa7ZRTivB/q6+OD1Z1l00urDhdxjHq3TjVokRYwHa2rEvsXPWovJH2y760OZUlzUOAx1dSnqYB9x1NWHwkGk0SqLn9divY8Rho+Ym33nW3YtVsawCMmCpwivhUqWqAJhrRrRuQKOp08OW/tFkCKXSkUDFtwVmw9TuMbchyzJmlOAoXyDLd27lAo+Byhlysm71/mCOoLfAQIDAQAB");
                String[] userIdAndKey = TokenUtils.getUserIdAndKey((String)data);
                this.userOnlineProvider.removeUserPrincipal(userIdAndKey[2]);
                this.userLoginCache.removeUserLogin(userIdAndKey[1]);
                AfterLoginCallback afterLoginCallback = (AfterLoginCallback)PlatformCallbackPostProcessor.getCallbackObject(AfterLoginCallback.class);
                if (afterLoginCallback != null) {
                    afterLoginCallback.onLogout(userIdAndKey[1]);
                }
                this.logger.debug("\u7528\u6237 logout success: " + userIdAndKey[1]);
            }
            catch (TokenException ex) {
                if (ex.isExpired()) {
                    this.recordLogoutInfo("null", "logout", "token\u8d85\u65f6\uff0c\u9000\u51fa\u64cd\u4f5c\u65e0\u6cd5\u5220\u9664\u7f13\u5b58");
                }
                this.recordLogoutInfo("null", "logout", "token\u8d85\u65f6\uff0c\u9000\u51fa\u64cd\u4f5c\u5f02\u5e38:" + ex.getMessage());
            }
        }
        ServletUtils.renderString((HttpServletResponse)response, (ResponseValue)ResponseValue.success((String)"\u9000\u51fa\u6210\u529f"));
    }

    private void recordLogoutInfo(String loginId, String status, String message) {
        this.logger.debug("\u5f02\u6b65\u8bb0\u5f55\u9000\u51fa\u65e5\u5fd7\uff0c\u540e\u7eed\u8981\u8865\u5145:" + status + ", " + message);
    }
}

