/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.model.po.S_user_core;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class DefaultUserDetails
implements UserDetails {
    private List<GrantedAuthority> grantedList = new ArrayList<GrantedAuthority>(4);
    private List<String> roleIdList = new ArrayList<String>(4);
    private UserPrincipal<S_user_core> userPrincipal = null;
    private static final Map<String, GrantedAuthority> gas = new HashMap<String, GrantedAuthority>(3);
    private String ip;

    public DefaultUserDetails(UserPrincipal<S_user_core> userPrincipal) {
        if (userPrincipal == null) {
            throw new IllegalArgumentException("UserPrincipal is required!");
        }
        this.userPrincipal = userPrincipal;
    }

    public UserPrincipal<S_user_core> getUserPrincipal() {
        return this.userPrincipal;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedList;
    }

    public String getPassword() {
        return this.userPrincipal.getPassword();
    }

    public String getUsername() {
        return this.userPrincipal.getUserName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return !this.userPrincipal.isAccountLocked();
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.userPrincipal.isEnabled();
    }

    public List<String> getRoleIdList() {
        return this.roleIdList;
    }

    public void setRoleIdListToPrincipal() {
        this.userPrincipal.setRoleIdList(this.roleIdList);
    }

    public boolean isSupervisor() {
        return ((S_user_core)this.userPrincipal.getUserInfo()).getUser_type() == 0;
    }

    public void addGrantedAuthority(String roleName) {
        if (StringUtils.isNotEmpty((String)roleName)) {
            GrantedAuthority ga = gas.get(roleName);
            if (ga == null) {
                ga = new SimpleGrantedAuthority(roleName);
                gas.put(roleName, ga);
            }
            this.grantedList.add(ga);
            if (!this.roleIdList.contains(roleName)) {
                this.roleIdList.add(roleName);
            }
        }
    }

    public boolean equals(Object o) {
        DefaultUserDetails _o;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return o instanceof DefaultUserDetails && (_o = (DefaultUserDetails)o).getUsername().equals(this.getUsername()) && _o.getPassword().equals(this.getPassword()) && _o.isEnabled() == this.isEnabled();
    }

    public int hashCode() {
        int result = 31;
        return result + 31 * this.getUsername().hashCode() + this.getPassword().hashCode() + 31 * (this.isEnabled() ? 1 : 0);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String toString() {
        return "[userDetails, name=" + this.getUsername() + "]";
    }
}

