/*
 * Decompiled with CFR 0.152.
 */
package com.iplatform.security;

import com.iplatform.base.DefaultUserPrincipal;
import com.iplatform.base.cache.MenuCacheProvider;
import com.iplatform.base.service.UserServiceImpl;
import com.iplatform.base.util.UserUtils;
import com.iplatform.model.po.S_menu;
import com.iplatform.model.po.S_user_core;
import com.iplatform.security.DefaultUserDetails;
import com.iplatform.security.config.SecurityProperties;
import com.walker.infrastructure.utils.PhoneNumberUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.UserPrincipal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class DefaultUserDetailsService
implements UserDetailsService {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserServiceImpl userService = null;
    private SecurityProperties securityProperties;
    private MenuCacheProvider menuCacheProvider;

    public void setMenuCacheProvider(MenuCacheProvider menuCacheProvider) {
        this.menuCacheProvider = menuCacheProvider;
    }

    public void setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public void setUserService(UserServiceImpl userService) {
        this.userService = userService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        this.logger.debug("loadUserByUsername = " + username);
        DefaultUserDetails userDetails = this.acquireUserPrincipal(username);
        if (userDetails == null) {
            throw new UsernameNotFoundException("not found user: " + username);
        }
        if (!userDetails.isEnabled()) {
            throw new UsernameNotFoundException("user is forbidden: " + username);
        }
        return userDetails;
    }

    public DefaultUserDetails acquireUserPrincipal(String loginId) {
        int userType;
        if (StringUtils.isEmpty((String)loginId)) {
            return null;
        }
        DefaultUserPrincipal userPrincipal = null;
        if (loginId.equals("supervisor")) {
            userPrincipal = (DefaultUserPrincipal)UserUtils.createSupervisor((String)this.securityProperties.getSupervisorPassword());
            DefaultUserDetails userDetails = new DefaultUserDetails((UserPrincipal<S_user_core>)userPrincipal);
            userDetails.addGrantedAuthority("ROLE_SUPERVISOR");
            userDetails.addGrantedAuthority("ROLE_ADMIN");
            userDetails.addGrantedAuthority("ROLE_USER");
            userDetails.setRoleIdListToPrincipal();
            return userDetails;
        }
        boolean isPhoneNumber = PhoneNumberUtils.isCellPhoneNumber((String)loginId);
        Object[] userInfo = null;
        userInfo = isPhoneNumber && !this.securityProperties.isUserNameIsPhone() ? this.userService.queryLoginUser(loginId, true) : this.userService.queryLoginUser(loginId, false);
        if (userInfo == null) {
            this.logger.debug("\u7528\u6237\u4e0d\u5b58\u5728: " + loginId);
            return null;
        }
        S_user_core user = (S_user_core)userInfo[0];
        List roleIdList = (List)userInfo[1];
        this.logger.debug("\u627e\u5230\u7528\u6237: " + user.getUser_name());
        userPrincipal = new DefaultUserPrincipal(user);
        userPrincipal.setLastLoginTime(System.currentTimeMillis());
        DefaultUserDetails userDetails = new DefaultUserDetails((UserPrincipal<S_user_core>)userPrincipal);
        if (roleIdList != null) {
            for (String roleId : roleIdList) {
                userDetails.addGrantedAuthority(roleId);
            }
        }
        if ((userType = ((S_user_core)userDetails.getUserPrincipal().getUserInfo()).getUser_type().intValue()) == 0) {
            userDetails.addGrantedAuthority("ROLE_SUPERVISOR");
            userDetails.addGrantedAuthority("ROLE_ADMIN");
            userDetails.addGrantedAuthority("ROLE_USER");
        } else if (userType == 1 || userType == 3) {
            userDetails.addGrantedAuthority("ROLE_ADMIN");
            userDetails.addGrantedAuthority("ROLE_USER");
        } else if (userType == 2) {
            userDetails.addGrantedAuthority("ROLE_USER");
        } else if (userType == 99) {
            userDetails.addGrantedAuthority("ROLE_USER");
        } else if (userType == 6) {
            userDetails.addGrantedAuthority("ROLE_MERCHANT");
            userDetails.addGrantedAuthority("ROLE_USER");
        } else {
            throw new IllegalArgumentException("unknown user type: " + userType);
        }
        userDetails.setRoleIdListToPrincipal();
        return userDetails;
    }

    @Deprecated
    private Map<String, String> acquireUserDataScopeList(List<String> roleIdList) {
        if (StringUtils.isEmptyList(roleIdList)) {
            return null;
        }
        List dataScopeMenuIdList = this.userService.queryUserDataScopeMenuIdList(roleIdList);
        if (StringUtils.isEmptyList((List)dataScopeMenuIdList)) {
            return null;
        }
        HashMap<String, String> dataScopeMap = new HashMap<String, String>(8);
        S_menu menu = null;
        for (String menuId : dataScopeMenuIdList) {
            menu = (S_menu)this.menuCacheProvider.getCacheData(menuId);
            if (menu == null) {
                throw new IllegalStateException("\u83dc\u5355\u7f13\u5b58\u4e0d\u5b58\u5728:" + menuId);
            }
            dataScopeMap.put(menu.getParent_id(), menuId.replaceFirst("data_scope,", ""));
        }
        return dataScopeMap;
    }
}

