package com.iplatform.security;

import com.iplatform.security.exception.PcUserStopAppException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseCode;
import com.walker.web.ResponseValue;
import com.walker.web.util.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.*;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import java.io.IOException;

public class DefaultAuthenticationFailureHandler implements AuthenticationFailureHandler {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void onAuthenticationFailure(HttpServletRequest request
            , HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String message = null;  //提示信息
        int code = ResponseCode.USER_CREDENTIALS_ERROR.getCode();         //错误编码

        if(exception instanceof AccountExpiredException){
            message = ResponseCode.USER_ACCOUNT_EXPIRED.getMessage();
            logger.debug("---------> " + message);
        }else if(exception instanceof BadCredentialsException){
            message = ResponseCode.USER_CREDENTIALS_ERROR.getMessage();
        }else if(exception instanceof CredentialsExpiredException){
            message = "密码过期,登录失败！";
        }else if(exception instanceof DisabledException){
            message = ResponseCode.USER_ACCOUNT_DISABLE.getMessage();
        }else if(exception instanceof LockedException){
            message = ResponseCode.USER_ACCOUNT_LOCKED.getMessage();
        }else if(exception instanceof InternalAuthenticationServiceException){
            message = ResponseCode.USER_CREDENTIALS_ERROR.getMessage();
        }else if(exception instanceof PcUserStopAppException){
            message = PcUserStopAppException.MESSAGE;
        }else{
            message = "登录失败！";
        }

        try {
            ServletUtils.renderString(response, JsonUtils.objectToJsonString(ResponseValue.error(message)));
        } catch (Exception e) {
            logger.error("认证失败:" + request.getRequestURI(), e);
        }
    }
}
