package com.iplatform.security;

import com.iplatform.base.UserLoginCache;
import com.iplatform.base.VariableConstants;
import com.iplatform.base.callback.AfterLoginCallback;
import com.iplatform.base.callback.PlatformCallbackPostProcessor;
import com.iplatform.base.util.TokenUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.ResponseValue;
import com.walker.web.TokenException;
import com.walker.web.TokenGenerator;
import com.walker.web.UserOnlineProvider;
import com.walker.web.util.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DefaultLogoutSuccessHandler implements LogoutSuccessHandler {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    private UserOnlineProvider userOnlineProvider;

    private TokenGenerator tokenGenerator;

    private UserLoginCache userLoginCache;

    public void setUserLoginCache(UserLoginCache userLoginCache) {
        this.userLoginCache = userLoginCache;
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public void setUserOnlineProvider(UserOnlineProvider userOnlineProvider) {
        this.userOnlineProvider = userOnlineProvider;
    }

    @Override
    public void onLogoutSuccess(HttpServletRequest request
            , HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String token = TokenUtils.getAuthorizationToken(request);
        if(StringUtils.isNotEmpty(token)){
            try{
                String data = tokenGenerator.validateToken(token, VariableConstants.TOKEN_SECRET);
                String[] userIdAndKey = TokenUtils.getUserIdAndKey(data);
                this.userOnlineProvider.removeUserPrincipal(userIdAndKey[2]);
                // 2023-07-11 用户登录策略缓存也删除
                this.userLoginCache.removeUserLogin(userIdAndKey[1]);

                // 2023-08-18，登录成功回调
                AfterLoginCallback afterLoginCallback = PlatformCallbackPostProcessor.getCallbackObject(AfterLoginCallback.class);
                if(afterLoginCallback != null){
                    afterLoginCallback.onLogout(userIdAndKey[1]);
                }

                logger.debug("用户 logout success: " + userIdAndKey[1]);
            } catch (TokenException ex){
                logger.error("logout注销时，token解析错误:" + ex.getMessage() + ", token=" + token, ex);
                if(ex.isExpired()){
                    this.recordLogoutInfo("null", "logout", "token超时，退出操作无法删除缓存");
                } else {
                    this.recordLogoutInfo("null", "logout", "token超时，退出操作异常:" + ex.getMessage());
                }
            }
        }
        ServletUtils.renderString(response, ResponseValue.success("退出成功"));
    }

    private void recordLogoutInfo(String loginId, String status, String message){
        logger.debug("异步记录退出日志，后续要补充:" + status + ", " + message);
    }

}
