package com.iplatform.security;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.web.ResponseCode;
import com.walker.web.ResponseValue;
import com.walker.web.util.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

import jakarta.servlet.ServletException;
import java.io.IOException;

/**
 * 匿名用户访问无权限资源时的异常。
 * @author 时克英
 * @date 2022-10-31
 */
public class FailedAuthenticationEntryPoint implements AuthenticationEntryPoint {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public void commence(jakarta.servlet.http.HttpServletRequest request
            , jakarta.servlet.http.HttpServletResponse response
            , AuthenticationException authException) throws IOException, ServletException {

        String msg = "认证失败，无权限访问系统资源" + request.getRequestURI();
        try {
            ServletUtils.renderString(response, JsonUtils.objectToJsonString(ResponseValue.error(ResponseCode.EXCEPTION.getCode(), msg)));
        } catch (Exception e) {
            logger.error("无权限访问系统资源" + request.getRequestURI());
        }
    }
}
