package com.iplatform.security.callback;

import com.iplatform.base.util.PlatformRSAUtils;
import com.iplatform.model.po.S_user_core;
import com.walker.web.CaptchaType;
import com.walker.web.UserPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * 移动端通过：账号、密码方式登录，<br>
 * 不需要任何验证码。
 * @author 时克英
 * @date 2023-03-20
 * @date 2023-04-07 修改名字为'密码加密'登录回调实现。
 */
public class EncryptPasswordLoginCallback extends
//        GeneralLoginCallback
        SimplePasswordLoginCallback
{

//    @Deprecated
//    @Override
//    public Object[] queryLoginUser(String loginId) {
//        return new Object[0];
//    }

    @Override
    public boolean validatePassword(UserPrincipal<S_user_core> userPrincipal) {
        Authentication usernamePasswordAuthenticationToken = SecurityContextHolder.getContext().getAuthentication();
        String password = usernamePasswordAuthenticationToken.getCredentials().toString();
        try {
            // APP传过来的密码是RSA加密内容。
//            byte[] data = RSAUtil.decryptByPrivateKey(password.getBytes(StandardCharsets.UTF_8), PRIK);
//            String pass = new String(data);
            // 2023-06-30 目前电商移动端登录：手机号 + 密码，使用的是明文密码，后续要改成一致。
            String originPassword = null;
            if(this.getCaptchaProvider().getCaptchaType() == CaptchaType.None){
//                originPassword = password;
                // 2023-08-06 uniapp端使用对称密码算法
                originPassword = PlatformRSAUtils.getAesDecryptValue(password);
            } else {
                originPassword = PlatformRSAUtils.getRsaDecryptValue(password, PlatformRSAUtils.PRIK);
            }
            logger.debug("......... 解密的password = {}", originPassword);
            return this.passwordEncoder.matches(originPassword, userPrincipal.getPassword());
        } catch (Exception e) {
            logger.error("", e);
            throw new RuntimeException("解析登录密码错误:" + e.getMessage(), e);
        }
    }

//    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
//        this.passwordEncoder = passwordEncoder;
//    }
//    private PasswordEncoder passwordEncoder = null;
}
